/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.CardinalityQRestriction;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.MaxCardinalityQRestriction;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityQRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.Iterator;
import junit.framework.TestSuite;

public class TestClassExpression
extends OntTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntResource;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$QualifiedRestriction;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$CardinalityQRestriction;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$MinCardinalityQRestriction;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$MaxCardinalityQRestriction;

    public static TestSuite suite() {
        return new TestClassExpression("TestClassExpression");
    }

    public TestClassExpression(String name) {
        super(name);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("OntClass.super-class", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                A.addSuperClass((Resource)B);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.SUB_CLASS_OF()));
                1.assertEquals((String)"A should have super-class B", (Object)B, (Object)A.getSuperClass());
                A.addSuperClass((Resource)C);
                1.assertEquals((String)"Cardinality should be 2", (int)2, (int)A.getCardinality(prof.SUB_CLASS_OF()));
                this.iteratorTest((Iterator)A.listSuperClasses(), new Object[]{C, B});
                A.setSuperClass((Resource)C);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.SUB_CLASS_OF()));
                1.assertEquals((String)"A shuold have super-class C", (Object)C, (Object)A.getSuperClass());
                1.assertTrue((String)"A shuold not have super-class B", (!A.hasSuperClass((Resource)B, false) ? 1 : 0) != 0);
                A.removeSuperClass((Resource)B);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.SUB_CLASS_OF()));
                A.removeSuperClass((Resource)C);
                1.assertEquals((String)"Cardinality should be 0", (int)0, (int)A.getCardinality(prof.SUB_CLASS_OF()));
            }
        }, new OntTestBase.OntTestCase("OntClass.sub-class", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                A.addSubClass((Resource)B);
                2.assertEquals((String)"Cardinality should be 1", (int)1, (int)B.getCardinality(prof.SUB_CLASS_OF()));
                2.assertEquals((String)"A should have sub-class B", (Object)B, (Object)A.getSubClass());
                A.addSubClass((Resource)C);
                2.assertEquals((String)"Cardinality should be 2", (int)2, (int)(B.getCardinality(prof.SUB_CLASS_OF()) + C.getCardinality(prof.SUB_CLASS_OF())));
                this.iteratorTest((Iterator)A.listSubClasses(), new Object[]{C, B});
                A.setSubClass((Resource)C);
                2.assertEquals((String)"Cardinality should be 1", (int)1, (int)(B.getCardinality(prof.SUB_CLASS_OF()) + C.getCardinality(prof.SUB_CLASS_OF())));
                2.assertEquals((String)"A shuold have sub-class C", (Object)C, (Object)A.getSubClass());
                2.assertTrue((String)"A shuold not have sub-class B", (!A.hasSubClass((Resource)B, false) ? 1 : 0) != 0);
                A.removeSubClass((Resource)B);
                2.assertTrue((String)"A should have sub-class C", (boolean)A.hasSubClass((Resource)C, false));
                A.removeSubClass((Resource)C);
                2.assertTrue((String)"A should not have sub-class C", (!A.hasSubClass((Resource)C, false) ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntClass.equivalentClass", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                A.addEquivalentClass((Resource)B);
                3.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.EQUIVALENT_CLASS()));
                3.assertEquals((String)"A have equivalentClass B", (Object)B, (Object)A.getEquivalentClass());
                A.addEquivalentClass((Resource)C);
                3.assertEquals((String)"Cardinality should be 2", (int)2, (int)A.getCardinality(prof.EQUIVALENT_CLASS()));
                this.iteratorTest((Iterator)A.listEquivalentClasses(), new Object[]{C, B});
                A.setEquivalentClass((Resource)C);
                3.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.EQUIVALENT_CLASS()));
                3.assertEquals((String)"A should have equivalentClass C", (Object)C, (Object)A.getEquivalentClass());
                3.assertTrue((String)"A should not have equivalentClass B", (!A.hasEquivalentClass((Resource)B) ? 1 : 0) != 0);
                A.removeEquivalentClass((Resource)B);
                3.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.EQUIVALENT_CLASS()));
                A.removeEquivalentClass((Resource)C);
                3.assertEquals((String)"Cardinality should be 0", (int)0, (int)A.getCardinality(prof.EQUIVALENT_CLASS()));
            }
        }, new OntTestBase.OntTestCase("OntClass.disjointWith", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                A.addDisjointWith((Resource)B);
                4.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.DISJOINT_WITH()));
                4.assertEquals((String)"A have be disjoint with B", (Object)B, (Object)A.getDisjointWith());
                A.addDisjointWith((Resource)C);
                4.assertEquals((String)"Cardinality should be 2", (int)2, (int)A.getCardinality(prof.DISJOINT_WITH()));
                this.iteratorTest((Iterator)A.listDisjointWith(), new Object[]{C, B});
                A.setDisjointWith((Resource)C);
                4.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.DISJOINT_WITH()));
                4.assertEquals((String)"A should be disjoint with C", (Object)C, (Object)A.getDisjointWith());
                4.assertTrue((String)"A should not be disjoint with B", (!A.isDisjointWith((Resource)B) ? 1 : 0) != 0);
                A.removeDisjointWith((Resource)B);
                4.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.DISJOINT_WITH()));
                A.removeDisjointWith((Resource)C);
                4.assertEquals((String)"Cardinality should be 0", (int)0, (int)A.getCardinality(prof.DISJOINT_WITH()));
            }
        }, new OntTestBase.OntTestCase("EnumeratedClass.oneOf", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                EnumeratedClass A = m.createEnumeratedClass("http://jena.hpl.hp.com/testing/ontology#A", null);
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestClassExpression.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource b = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestClassExpression.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                A.addOneOf((Resource)a);
                5.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.ONE_OF()));
                5.assertEquals((String)"Size should be 1", (int)1, (int)A.getOneOf().size());
                5.assertTrue((String)"A should have a as enumerated member", (boolean)A.getOneOf().contains((RDFNode)a));
                A.addOneOf((Resource)b);
                5.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.ONE_OF()));
                5.assertEquals((String)"Size should be 2", (int)2, (int)A.getOneOf().size());
                this.iteratorTest((Iterator)A.listOneOf(), new Object[]{a, b});
                A.setOneOf(m.createList(new RDFNode[]{b}));
                5.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.ONE_OF()));
                5.assertEquals((String)"Size should be 1", (int)1, (int)A.getOneOf().size());
                5.assertTrue((String)"A should have b in the enum", (boolean)A.hasOneOf((Resource)b));
                5.assertTrue((String)"A should not have a in the enum", (!A.hasOneOf((Resource)a) ? 1 : 0) != 0);
                A.removeOneOf((Resource)a);
                5.assertTrue((String)"Should have b as an enum value", (boolean)A.hasOneOf((Resource)b));
                A.removeOneOf((Resource)b);
                5.assertTrue((String)"Should not have b as an enum value", (!A.hasOneOf((Resource)b) ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("IntersectionClass.intersectionOf", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                IntersectionClass A = m.createIntersectionClass("http://jena.hpl.hp.com/testing/ontology#A", null);
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                A.addOperand((Resource)B);
                6.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.INTERSECTION_OF()));
                6.assertEquals((String)"Size should be 1", (int)1, (int)A.getOperands().size());
                6.assertTrue((String)"A should have a as intersection member", (boolean)A.getOperands().contains((RDFNode)B));
                A.addOperand((Resource)C);
                6.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.INTERSECTION_OF()));
                6.assertEquals((String)"Size should be 2", (int)2, (int)A.getOperands().size());
                this.iteratorTest((Iterator)A.listOperands(), new Object[]{B, C});
                ExtendedIterator i = A.listOperands();
                6.assertTrue((String)"Argument should be an OntClass", (boolean)(i.next() instanceof OntClass));
                i.close();
                A.setOperands(m.createList(new RDFNode[]{C}));
                6.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.INTERSECTION_OF()));
                6.assertEquals((String)"Size should be 1", (int)1, (int)A.getOperands().size());
                6.assertTrue((String)"A should have C in the intersection", (boolean)A.hasOperand((Resource)C));
                6.assertTrue((String)"A should not have B in the intersection", (!A.hasOperand((Resource)B) ? 1 : 0) != 0);
                A.removeOperand((Resource)B);
                6.assertTrue((String)"Should have C as an operand", (boolean)A.hasOperand((Resource)C));
                A.removeOperand((Resource)C);
                6.assertTrue((String)"Should not have C as an operand", (!A.hasOperand((Resource)C) ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("UnionClass.unionOf", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                UnionClass A = m.createUnionClass("http://jena.hpl.hp.com/testing/ontology#A", null);
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                A.addOperand((Resource)B);
                7.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.UNION_OF()));
                7.assertEquals((String)"Size should be 1", (int)1, (int)A.getOperands().size());
                7.assertTrue((String)"A should have a as union member", (boolean)A.getOperands().contains((RDFNode)B));
                A.addOperand((Resource)C);
                7.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.UNION_OF()));
                7.assertEquals((String)"Size should be 2", (int)2, (int)A.getOperands().size());
                this.iteratorTest((Iterator)A.listOperands(), new Object[]{B, C});
                ExtendedIterator i = A.listOperands();
                7.assertTrue((String)"Argument should be an OntClass", (boolean)(i.next() instanceof OntClass));
                i.close();
                A.setOperands(m.createList(new RDFNode[]{C}));
                7.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.UNION_OF()));
                7.assertEquals((String)"Size should be 1", (int)1, (int)A.getOperands().size());
                7.assertTrue((String)"A should have C in the union", (boolean)A.hasOperand((Resource)C));
                7.assertTrue((String)"A should not have B in the union", (!A.hasOperand((Resource)B) ? 1 : 0) != 0);
                A.removeOperand((Resource)B);
                7.assertTrue((String)"Should have C as an operand", (boolean)A.hasOperand((Resource)C));
                A.removeOperand((Resource)C);
                7.assertTrue((String)"Should not have C as an operand", (!A.hasOperand((Resource)C) ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("ComplementClass.complementOf", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ComplementClass A = m.createComplementClass("http://jena.hpl.hp.com/testing/ontology#A", null);
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                boolean ex = false;
                try {
                    A.addOperand((Resource)B);
                }
                catch (UnsupportedOperationException e) {
                    ex = true;
                }
                8.assertTrue((String)"Should fail to add to a complement", (boolean)ex);
                ex = false;
                try {
                    A.addOperands((Iterator)NullIterator.instance);
                }
                catch (UnsupportedOperationException e) {
                    ex = true;
                }
                8.assertTrue((String)"Should fail to add to a complement", (boolean)ex);
                ex = false;
                try {
                    A.setOperands(m.createList(new RDFNode[]{C}));
                }
                catch (UnsupportedOperationException e) {
                    ex = true;
                }
                8.assertTrue((String)"Should fail to set a list to a complement", (boolean)ex);
                A.setOperand((Resource)B);
                8.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.COMPLEMENT_OF()));
                8.assertEquals((String)"Complement should be B", (Object)B, (Object)A.getOperand());
                this.iteratorTest((Iterator)A.listOperands(), new Object[]{B});
                A.setOperand((Resource)C);
                8.assertEquals((String)"Cardinality should be 1", (int)1, (int)A.getCardinality(prof.COMPLEMENT_OF()));
                8.assertTrue((String)"A should have C in the complement", (boolean)A.hasOperand((Resource)C));
                8.assertTrue((String)"A should not have B in the complement", (!A.hasOperand((Resource)B) ? 1 : 0) != 0);
                A.removeOperand((Resource)B);
                8.assertTrue((String)"Should have C as an operand", (boolean)A.hasOperand((Resource)C));
                A.removeOperand((Resource)C);
                8.assertTrue((String)"Should not have C as an operand", (!A.hasOperand((Resource)C) ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.onProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ObjectProperty q = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                AllValuesFromRestriction A = m.createAllValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", (Property)p, (Resource)B);
                9.assertEquals((String)"Restriction should be on property p", (Object)p, (Object)A.getOnProperty());
                9.assertTrue((String)"Restriction should be on property p", (boolean)A.onProperty((Property)p));
                9.assertTrue((String)"Restriction should not be on property q", (!A.onProperty((Property)q) ? 1 : 0) != 0);
                9.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.ON_PROPERTY()));
                A.setOnProperty((Property)q);
                9.assertEquals((String)"Restriction should be on property q", (Object)q, (Object)A.getOnProperty());
                9.assertTrue((String)"Restriction should not be on property p", (!A.onProperty((Property)p) ? 1 : 0) != 0);
                9.assertTrue((String)"Restriction should not on property q", (boolean)A.onProperty((Property)q));
                9.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.ON_PROPERTY()));
                A.removeOnProperty((Property)p);
                9.assertTrue((String)"Should have q as on property", (boolean)A.onProperty((Property)q));
                A.removeOnProperty((Property)q);
                9.assertTrue((String)"Should not have q as on property", (!A.onProperty((Property)q) ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("AllValuesFromRestriction.allValuesFrom", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                AllValuesFromRestriction A = m.createAllValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", (Property)p, (Resource)B);
                10.assertEquals((String)"Restriction should be all values from B", (Object)B, (Object)A.getAllValuesFrom());
                10.assertTrue((String)"Restriction should be all values from B", (boolean)A.hasAllValuesFrom((Resource)B));
                10.assertTrue((String)"Restriction should not be all values from C", (!A.hasAllValuesFrom((Resource)C) ? 1 : 0) != 0);
                10.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.ALL_VALUES_FROM()));
                A.setAllValuesFrom((Resource)C);
                10.assertEquals((String)"Restriction should be all values from C", (Object)C, (Object)A.getAllValuesFrom());
                10.assertTrue((String)"Restriction should not be all values from B", (!A.hasAllValuesFrom((Resource)B) ? 1 : 0) != 0);
                10.assertTrue((String)"Restriction should be all values from C", (boolean)A.hasAllValuesFrom((Resource)C));
                10.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.ALL_VALUES_FROM()));
                A.removeAllValuesFrom((Resource)C);
                10.assertTrue((String)"Restriction should not be some values from C", (!A.hasAllValuesFrom((Resource)C) ? 1 : 0) != 0);
                10.assertEquals((String)"cardinality should be 0 ", (int)0, (int)A.getCardinality(prof.ALL_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("AllValuesFromRestriction.allValuesFrom.datatype", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                AllValuesFromRestriction A = m.createAllValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", (Property)p, XSD.gDay);
                11.assertEquals((String)"Restriction should be all values from gDay", (Object)XSD.gDay, (Object)A.getAllValuesFrom());
                11.assertTrue((String)"Restriction should be all values from gDay", (boolean)A.hasAllValuesFrom(XSD.gDay));
                11.assertTrue((String)"Restriction should not be all values from decimal", (!A.hasAllValuesFrom(XSD.decimal) ? 1 : 0) != 0);
                11.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.ALL_VALUES_FROM()));
                A.setAllValuesFrom(XSD.gMonth);
                11.assertEquals((String)"Restriction should be all values from gMonth", (Object)XSD.gMonth, (Object)A.getAllValuesFrom());
                11.assertTrue((String)"Restriction should not be all values from gDay", (!A.hasAllValuesFrom(XSD.gDay) ? 1 : 0) != 0);
                11.assertTrue((String)"Restriction should be all values from gMonth", (boolean)A.hasAllValuesFrom(XSD.gMonth));
                11.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.ALL_VALUES_FROM()));
                A.removeAllValuesFrom(XSD.gMonth);
                11.assertTrue((String)"Restriction should not be some values from gMonth", (!A.hasAllValuesFrom(XSD.gMonth) ? 1 : 0) != 0);
                11.assertEquals((String)"cardinality should be 0 ", (int)0, (int)A.getCardinality(prof.ALL_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("AllValuesFromRestriction.allValuesFrom.literal", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                AllValuesFromRestriction A = m.createAllValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", (Property)p, RDFS.Literal);
                12.assertEquals((String)"Restriction should be all values from literal", (Object)RDFS.Literal, (Object)A.getAllValuesFrom());
                12.assertTrue((String)"Restriction should be all values from literal", (boolean)A.hasAllValuesFrom(RDFS.Literal));
                12.assertTrue((String)"Restriction should not be all values from decimal", (!A.hasAllValuesFrom(XSD.decimal) ? 1 : 0) != 0);
                12.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.ALL_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("AllValuesFromRestriction.allValuesFrom.datarange", true, false, false, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                Literal x = m.createLiteral(1L);
                Literal y = m.createLiteral(2L);
                DataRange dr = m.createDataRange(m.createList(new RDFNode[]{x, y}));
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                AllValuesFromRestriction A = m.createAllValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", (Property)p, (Resource)dr);
                13.assertEquals((String)"Restriction should be all values from dr", (Object)dr, (Object)A.getAllValuesFrom());
                13.assertTrue((String)"value should be a datarange", (boolean)(A.getAllValuesFrom() instanceof DataRange));
                13.assertTrue((String)"Restriction should be all values from dr", (boolean)A.hasAllValuesFrom((Resource)dr));
                13.assertTrue((String)"Restriction should not be all values from decimal", (!A.hasAllValuesFrom(XSD.decimal) ? 1 : 0) != 0);
                13.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.ALL_VALUES_FROM()));
                A.removeAllValuesFrom((Resource)dr);
                13.assertTrue((String)"Restriction should not be some values from gMonth", (!A.hasAllValuesFrom((Resource)dr) ? 1 : 0) != 0);
                13.assertEquals((String)"cardinality should be 0 ", (int)0, (int)A.getCardinality(prof.ALL_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("HasValueRestriction.hasValue", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual b = m.createIndividual((Resource)B);
                OntClass C = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                Individual c = m.createIndividual((Resource)C);
                HasValueRestriction A = m.createHasValueRestriction("http://jena.hpl.hp.com/testing/ontology#A", (Property)p, (RDFNode)b);
                14.assertEquals((String)"Restriction should be has value b", (Object)b, (Object)A.getHasValue());
                14.assertTrue((String)"Restriction should be to have value b", (boolean)A.hasValue((RDFNode)b));
                14.assertTrue((String)"Restriction should not be have value c", (!A.hasValue((RDFNode)c) ? 1 : 0) != 0);
                14.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.HAS_VALUE()));
                A.setHasValue((RDFNode)c);
                14.assertEquals((String)"Restriction should be has value c", (Object)c, (Object)A.getHasValue());
                14.assertTrue((String)"Restriction should not be to have value b", (!A.hasValue((RDFNode)b) ? 1 : 0) != 0);
                14.assertTrue((String)"Restriction should not be have value c", (boolean)A.hasValue((RDFNode)c));
                14.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.HAS_VALUE()));
                A.removeHasValue((RDFNode)c);
                14.assertTrue((String)"Restriction should not be to have value b", (!A.hasValue((RDFNode)b) ? 1 : 0) != 0);
                14.assertTrue((String)"Restriction should not be have value c", (!A.hasValue((RDFNode)c) ? 1 : 0) != 0);
                14.assertEquals((String)"cardinality should be 0 ", (int)0, (int)A.getCardinality(prof.HAS_VALUE()));
            }
        }, new OntTestBase.OntTestCase("SomeValuesFromRestriction.someValuesFrom", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                SomeValuesFromRestriction A = m.createSomeValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", (Property)p, (Resource)B);
                15.assertEquals((String)"Restriction should be some values from B", (Object)B, (Object)A.getSomeValuesFrom());
                15.assertTrue((String)"Restriction should be some values from B", (boolean)A.hasSomeValuesFrom((Resource)B));
                15.assertTrue((String)"Restriction should not be some values from C", (!A.hasSomeValuesFrom((Resource)C) ? 1 : 0) != 0);
                15.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.SOME_VALUES_FROM()));
                A.setSomeValuesFrom((Resource)C);
                15.assertEquals((String)"Restriction should be some values from C", (Object)C, (Object)A.getSomeValuesFrom());
                15.assertTrue((String)"Restriction should not be some values from B", (!A.hasSomeValuesFrom((Resource)B) ? 1 : 0) != 0);
                15.assertTrue((String)"Restriction should be some values from C", (boolean)A.hasSomeValuesFrom((Resource)C));
                15.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.SOME_VALUES_FROM()));
                A.removeSomeValuesFrom((Resource)C);
                15.assertTrue((String)"Restriction should not be some values from C", (!A.hasSomeValuesFrom((Resource)C) ? 1 : 0) != 0);
                15.assertEquals((String)"cardinality should be 0 ", (int)0, (int)A.getCardinality(prof.SOME_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("SomeValuesFromRestriction.SomeValuesFrom.datatype", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                SomeValuesFromRestriction A = m.createSomeValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", (Property)p, XSD.gDay);
                16.assertEquals((String)"Restriction should be some values from gDay", (Object)XSD.gDay, (Object)A.getSomeValuesFrom());
                16.assertTrue((String)"Restriction should be some values from gDay", (boolean)A.hasSomeValuesFrom(XSD.gDay));
                16.assertTrue((String)"Restriction should not be some values from decimal", (!A.hasSomeValuesFrom(XSD.decimal) ? 1 : 0) != 0);
                16.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.SOME_VALUES_FROM()));
                A.setSomeValuesFrom(XSD.gMonth);
                16.assertEquals((String)"Restriction should be some values from gMonth", (Object)XSD.gMonth, (Object)A.getSomeValuesFrom());
                16.assertTrue((String)"Restriction should not be some values from gDay", (!A.hasSomeValuesFrom(XSD.gDay) ? 1 : 0) != 0);
                16.assertTrue((String)"Restriction should be some values from gMonth", (boolean)A.hasSomeValuesFrom(XSD.gMonth));
                16.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.SOME_VALUES_FROM()));
                A.removeSomeValuesFrom(XSD.gMonth);
                16.assertTrue((String)"Restriction should not be some values from gMonth", (!A.hasSomeValuesFrom(XSD.gMonth) ? 1 : 0) != 0);
                16.assertEquals((String)"cardinality should be 0 ", (int)0, (int)A.getCardinality(prof.SOME_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("SomeValuesFromRestriction.SomeValuesFrom.literal", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                SomeValuesFromRestriction A = m.createSomeValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", (Property)p, RDFS.Literal);
                17.assertEquals((String)"Restriction should be some values from literal", (Object)RDFS.Literal, (Object)A.getSomeValuesFrom());
                17.assertTrue((String)"Restriction should be some values from literal", (boolean)A.hasSomeValuesFrom(RDFS.Literal));
                17.assertTrue((String)"Restriction should not be some values from decimal", (!A.hasSomeValuesFrom(XSD.decimal) ? 1 : 0) != 0);
                17.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.SOME_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("SomeValuesFromRestriction.SomeValuesFrom.datarange", true, false, false, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                Literal x = m.createLiteral(1L);
                Literal y = m.createLiteral(2L);
                DataRange dr = m.createDataRange(m.createList(new RDFNode[]{x, y}));
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                SomeValuesFromRestriction A = m.createSomeValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", (Property)p, (Resource)dr);
                18.assertEquals((String)"Restriction should be some values from dr", (Object)dr, (Object)A.getSomeValuesFrom());
                18.assertTrue((String)"value should be a datarange", (boolean)(A.getSomeValuesFrom() instanceof DataRange));
                18.assertTrue((String)"Restriction should be some values from dr", (boolean)A.hasSomeValuesFrom((Resource)dr));
                18.assertTrue((String)"Restriction should not be some values from decimal", (!A.hasSomeValuesFrom(XSD.decimal) ? 1 : 0) != 0);
                18.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.SOME_VALUES_FROM()));
                A.removeSomeValuesFrom((Resource)dr);
                18.assertTrue((String)"Restriction should not be some values from gMonth", (!A.hasSomeValuesFrom((Resource)dr) ? 1 : 0) != 0);
                18.assertEquals((String)"cardinality should be 0 ", (int)0, (int)A.getCardinality(prof.SOME_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("CardinalityRestriction.cardinality", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                CardinalityRestriction A = m.createCardinalityRestriction("http://jena.hpl.hp.com/testing/ontology#A", (Property)p, 3);
                19.assertEquals((String)"Restriction should be cardinality 3", (int)3, (int)A.getCardinality());
                19.assertTrue((String)"Restriction should be cardinality 3", (boolean)A.hasCardinality(3));
                19.assertTrue((String)"Restriction should not be cardinality 2", (!A.hasCardinality(2) ? 1 : 0) != 0);
                19.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.CARDINALITY()));
                A.setCardinality(2);
                19.assertEquals((String)"Restriction should be cardinality 2", (int)2, (int)A.getCardinality());
                19.assertTrue((String)"Restriction should not be cardinality 3", (!A.hasCardinality(3) ? 1 : 0) != 0);
                19.assertTrue((String)"Restriction should be cardinality 2", (boolean)A.hasCardinality(2));
                19.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.CARDINALITY()));
                A.removeCardinality(2);
                19.assertTrue((String)"Restriction should not be cardinality 3", (!A.hasCardinality(3) ? 1 : 0) != 0);
                19.assertTrue((String)"Restriction should not be cardinality 2", (!A.hasCardinality(2) ? 1 : 0) != 0);
                19.assertEquals((String)"cardinality should be 0 ", (int)0, (int)A.getCardinality(prof.CARDINALITY()));
            }
        }, new OntTestBase.OntTestCase("MinCardinalityRestriction.minCardinality", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                MinCardinalityRestriction A = m.createMinCardinalityRestriction("http://jena.hpl.hp.com/testing/ontology#A", (Property)p, 3);
                20.assertEquals((String)"Restriction should be min cardinality 3", (int)3, (int)A.getMinCardinality());
                20.assertTrue((String)"Restriction should be min cardinality 3", (boolean)A.hasMinCardinality(3));
                20.assertTrue((String)"Restriction should not be min cardinality 2", (!A.hasMinCardinality(2) ? 1 : 0) != 0);
                20.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.MIN_CARDINALITY()));
                A.setMinCardinality(2);
                20.assertEquals((String)"Restriction should be min cardinality 2", (int)2, (int)A.getMinCardinality());
                20.assertTrue((String)"Restriction should not be min cardinality 3", (!A.hasMinCardinality(3) ? 1 : 0) != 0);
                20.assertTrue((String)"Restriction should be min cardinality 2", (boolean)A.hasMinCardinality(2));
                20.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.MIN_CARDINALITY()));
                A.removeMinCardinality(2);
                20.assertTrue((String)"Restriction should not be cardinality 3", (!A.hasMinCardinality(3) ? 1 : 0) != 0);
                20.assertTrue((String)"Restriction should not be cardinality 2", (!A.hasMinCardinality(2) ? 1 : 0) != 0);
                20.assertEquals((String)"cardinality should be 0 ", (int)0, (int)A.getCardinality(prof.MIN_CARDINALITY()));
            }
        }, new OntTestBase.OntTestCase("MaxCardinalityRestriction.maxCardinality", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                MaxCardinalityRestriction A = m.createMaxCardinalityRestriction("http://jena.hpl.hp.com/testing/ontology#A", (Property)p, 3);
                21.assertEquals((String)"Restriction should be max cardinality 3", (int)3, (int)A.getMaxCardinality());
                21.assertTrue((String)"Restriction should be max cardinality 3", (boolean)A.hasMaxCardinality(3));
                21.assertTrue((String)"Restriction should not be max cardinality 2", (!A.hasMaxCardinality(2) ? 1 : 0) != 0);
                21.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.MAX_CARDINALITY()));
                A.setMaxCardinality(2);
                21.assertEquals((String)"Restriction should be max cardinality 2", (int)2, (int)A.getMaxCardinality());
                21.assertTrue((String)"Restriction should not be max cardinality 3", (!A.hasMaxCardinality(3) ? 1 : 0) != 0);
                21.assertTrue((String)"Restriction should be max cardinality 2", (boolean)A.hasMaxCardinality(2));
                21.assertEquals((String)"cardinality should be 1 ", (int)1, (int)A.getCardinality(prof.MAX_CARDINALITY()));
                A.removeMaxCardinality(2);
                21.assertTrue((String)"Restriction should not be cardinality 3", (!A.hasMaxCardinality(3) ? 1 : 0) != 0);
                21.assertTrue((String)"Restriction should not be cardinality 2", (!A.hasMaxCardinality(2) ? 1 : 0) != 0);
                21.assertEquals((String)"cardinality should be 0 ", (int)0, (int)A.getCardinality(prof.MAX_CARDINALITY()));
            }
        }, new OntTestBase.OntTestCase("QualifiedRestriction.hasClassQ", false, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                OntClass d = m.createClass("http://jena.hpl.hp.com/testing/ontology#D");
                MaxCardinalityQRestriction A = m.createMaxCardinalityQRestriction("http://jena.hpl.hp.com/testing/ontology#A", (Property)p, 3, c);
                22.assertEquals((String)"Restriction should hasClassQ c", (Object)c, (Object)A.getHasClassQ());
                22.assertTrue((String)"Restriction should be hasClassQ c", (boolean)A.hasHasClassQ(c));
                22.assertFalse((String)"Restriction should not be hasClassQ d", (boolean)A.hasHasClassQ(d));
                A.setHasClassQ(d);
                22.assertEquals((String)"Restriction should hasClassQ d", (Object)d, (Object)A.getHasClassQ());
                22.assertTrue((String)"Restriction should be hasClassQ d", (boolean)A.hasHasClassQ(d));
                22.assertFalse((String)"Restriction should not be hasClassQ c", (boolean)A.hasHasClassQ(c));
                22.assertTrue((String)"Should be a qualified restriction", (boolean)m.getResource("http://jena.hpl.hp.com/testing/ontology#A").canAs(class$com$hp$hpl$jena$ontology$QualifiedRestriction == null ? (class$com$hp$hpl$jena$ontology$QualifiedRestriction = TestClassExpression.class$("com.hp.hpl.jena.ontology.QualifiedRestriction")) : class$com$hp$hpl$jena$ontology$QualifiedRestriction));
                A.removeHasClassQ(d);
                22.assertFalse((String)"Should not be a qualified restriction", (boolean)m.getResource("http://jena.hpl.hp.com/testing/ontology#A").canAs(class$com$hp$hpl$jena$ontology$QualifiedRestriction == null ? (class$com$hp$hpl$jena$ontology$QualifiedRestriction = TestClassExpression.class$("com.hp.hpl.jena.ontology.QualifiedRestriction")) : class$com$hp$hpl$jena$ontology$QualifiedRestriction));
            }
        }, new OntTestBase.OntTestCase("CardinalityQRestriction.cardinality", false, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                CardinalityQRestriction A = m.createCardinalityQRestriction("http://jena.hpl.hp.com/testing/ontology#A", (Property)p, 3, c);
                23.assertEquals((String)"Restriction should cardinality 3", (int)3, (int)A.getCardinalityQ());
                23.assertTrue((String)"Restriction should be cardinality 3", (boolean)A.hasCardinalityQ(3));
                23.assertFalse((String)"Restriction should not be cardinality 1", (boolean)A.hasCardinalityQ(1));
                A.setCardinalityQ(1);
                23.assertEquals((String)"Restriction should cardinality 1", (int)1, (int)A.getCardinalityQ());
                23.assertFalse((String)"Restriction should not be cardinality 3", (boolean)A.hasCardinalityQ(3));
                23.assertTrue((String)"Restriction should be cardinality 1", (boolean)A.hasCardinalityQ(1));
                23.assertTrue((String)"Should be a qualified cardinality restriction", (boolean)m.getResource("http://jena.hpl.hp.com/testing/ontology#A").canAs(class$com$hp$hpl$jena$ontology$CardinalityQRestriction == null ? (class$com$hp$hpl$jena$ontology$CardinalityQRestriction = TestClassExpression.class$("com.hp.hpl.jena.ontology.CardinalityQRestriction")) : class$com$hp$hpl$jena$ontology$CardinalityQRestriction));
                A.removeCardinalityQ(1);
                23.assertFalse((String)"Should not be a qualified cardinality restriction", (boolean)m.getResource("http://jena.hpl.hp.com/testing/ontology#A").canAs(class$com$hp$hpl$jena$ontology$CardinalityQRestriction == null ? (class$com$hp$hpl$jena$ontology$CardinalityQRestriction = TestClassExpression.class$("com.hp.hpl.jena.ontology.CardinalityQRestriction")) : class$com$hp$hpl$jena$ontology$CardinalityQRestriction));
            }
        }, new OntTestBase.OntTestCase("MinCardinalityQRestriction.minCardinality", false, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                MinCardinalityQRestriction A = m.createMinCardinalityQRestriction("http://jena.hpl.hp.com/testing/ontology#A", (Property)p, 3, c);
                24.assertEquals((String)"Restriction should min cardinality 3", (int)3, (int)A.getMinCardinalityQ());
                24.assertTrue((String)"Restriction should be min cardinality 3", (boolean)A.hasMinCardinalityQ(3));
                24.assertFalse((String)"Restriction should not be min cardinality 1", (boolean)A.hasMinCardinalityQ(1));
                A.setMinCardinalityQ(1);
                24.assertEquals((String)"Restriction should min cardinality 1", (int)1, (int)A.getMinCardinalityQ());
                24.assertFalse((String)"Restriction should not be min cardinality 3", (boolean)A.hasMinCardinalityQ(3));
                24.assertTrue((String)"Restriction should be min cardinality 1", (boolean)A.hasMinCardinalityQ(1));
                24.assertTrue((String)"Should be a qualified min cardinality restriction", (boolean)m.getResource("http://jena.hpl.hp.com/testing/ontology#A").canAs(class$com$hp$hpl$jena$ontology$MinCardinalityQRestriction == null ? (class$com$hp$hpl$jena$ontology$MinCardinalityQRestriction = TestClassExpression.class$("com.hp.hpl.jena.ontology.MinCardinalityQRestriction")) : class$com$hp$hpl$jena$ontology$MinCardinalityQRestriction));
                A.removeMinCardinalityQ(1);
                24.assertFalse((String)"Should not be a qualified min cardinality restriction", (boolean)m.getResource("http://jena.hpl.hp.com/testing/ontology#A").canAs(class$com$hp$hpl$jena$ontology$MinCardinalityQRestriction == null ? (class$com$hp$hpl$jena$ontology$MinCardinalityQRestriction = TestClassExpression.class$("com.hp.hpl.jena.ontology.MinCardinalityQRestriction")) : class$com$hp$hpl$jena$ontology$MinCardinalityQRestriction));
            }
        }, new OntTestBase.OntTestCase("MaxCardinalityQRestriction.maxCardinality", false, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                MaxCardinalityQRestriction A = m.createMaxCardinalityQRestriction("http://jena.hpl.hp.com/testing/ontology#A", (Property)p, 3, c);
                25.assertEquals((String)"Restriction should max cardinality 3", (int)3, (int)A.getMaxCardinalityQ());
                25.assertTrue((String)"Restriction should be max cardinality 3", (boolean)A.hasMaxCardinalityQ(3));
                25.assertFalse((String)"Restriction should not be max cardinality 1", (boolean)A.hasMaxCardinalityQ(1));
                A.setMaxCardinalityQ(1);
                25.assertEquals((String)"Restriction should max cardinality 1", (int)1, (int)A.getMaxCardinalityQ());
                25.assertFalse((String)"Restriction should not be max cardinality 3", (boolean)A.hasMaxCardinalityQ(3));
                25.assertTrue((String)"Restriction should be max cardinality 1", (boolean)A.hasMaxCardinalityQ(1));
                25.assertTrue((String)"Should be a qualified max cardinality restriction", (boolean)m.getResource("http://jena.hpl.hp.com/testing/ontology#A").canAs(class$com$hp$hpl$jena$ontology$MaxCardinalityQRestriction == null ? (class$com$hp$hpl$jena$ontology$MaxCardinalityQRestriction = TestClassExpression.class$("com.hp.hpl.jena.ontology.MaxCardinalityQRestriction")) : class$com$hp$hpl$jena$ontology$MaxCardinalityQRestriction));
                A.removeMaxCardinalityQ(1);
                25.assertFalse((String)"Should not be a qualified max cardinality restriction", (boolean)m.getResource("http://jena.hpl.hp.com/testing/ontology#A").canAs(class$com$hp$hpl$jena$ontology$MaxCardinalityQRestriction == null ? (class$com$hp$hpl$jena$ontology$MaxCardinalityQRestriction = TestClassExpression.class$("com.hp.hpl.jena.ontology.MaxCardinalityQRestriction")) : class$com$hp$hpl$jena$ontology$MaxCardinalityQRestriction));
            }
        }, new OntTestBase.OntTestCase("OntClass.subclass.fromFile", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                String lang = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String fileName = "file:testing/ontology/" + lang + "/ClassExpression/test.rdf";
                m.read(fileName);
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#ClassA");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#ClassB");
                this.iteratorTest((Iterator)A.listSuperClasses(), new Object[]{B});
                this.iteratorTest((Iterator)B.listSubClasses(), new Object[]{A});
            }
        }, new OntTestBase.OntTestCase("OntClass.equivalentClass.fromFile", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                String lang = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String fileName = "file:testing/ontology/" + lang + "/ClassExpression/test.rdf";
                m.read(fileName);
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#ClassA");
                OntClass C = m.createClass("http://jena.hpl.hp.com/testing/ontology#ClassC");
                27.assertTrue((String)"A should be equiv to C", (boolean)A.hasEquivalentClass((Resource)C));
            }
        }, new OntTestBase.OntTestCase("OntClass.disjoint.fromFile", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                String lang = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String fileName = "file:testing/ontology/" + lang + "/ClassExpression/test.rdf";
                m.read(fileName);
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#ClassA");
                OntClass D = m.createClass("http://jena.hpl.hp.com/testing/ontology#ClassD");
                28.assertTrue((String)"A should be disjoint with D", (boolean)A.isDisjointWith((Resource)D));
            }
        }, new OntTestBase.OntTestCase("OntClass.isEnumeratedClass", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual x = m.createIndividual("http://jena.hpl.hp.com/testing/ontology#x", (Resource)b);
                Individual y = m.createIndividual("http://jena.hpl.hp.com/testing/ontology#y", (Resource)b);
                EnumeratedClass a = m.createEnumeratedClass("http://jena.hpl.hp.com/testing/ontology#A", m.createList(new RDFNode[]{x, y}));
                29.assertTrue((String)"enumerated class test not correct", (boolean)a.isEnumeratedClass());
                29.assertTrue((String)"intersection class test not correct", (!a.isIntersectionClass() ? 1 : 0) != 0);
                29.assertTrue((String)"union class test not correct", (!a.isUnionClass() ? 1 : 0) != 0);
                29.assertTrue((String)"complement class test not correct", (!a.isComplementClass() ? 1 : 0) != 0);
                29.assertTrue((String)"restriction test not correct", (!a.isRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntClass.isIntersectionClass", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                IntersectionClass a = m.createIntersectionClass("http://jena.hpl.hp.com/testing/ontology#A", m.createList(new RDFNode[]{b, c}));
                30.assertTrue((String)"enumerated class test not correct", (this.m_owlLiteLang || !a.isEnumeratedClass() ? 1 : 0) != 0);
                30.assertTrue((String)"intersection class test not correct", (boolean)a.isIntersectionClass());
                30.assertTrue((String)"union class test not correct", (this.m_owlLiteLang || !a.isUnionClass() ? 1 : 0) != 0);
                30.assertTrue((String)"complement class test not correct", (this.m_owlLiteLang || !a.isComplementClass() ? 1 : 0) != 0);
                30.assertTrue((String)"restriction test not correct", (!a.isRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntClass.isUnionClass", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                UnionClass a = m.createUnionClass("http://jena.hpl.hp.com/testing/ontology#A", m.createList(new RDFNode[]{b, c}));
                31.assertTrue((String)"enumerated class test not correct", (!a.isEnumeratedClass() ? 1 : 0) != 0);
                31.assertTrue((String)"intersection class test not correct", (!a.isIntersectionClass() ? 1 : 0) != 0);
                31.assertTrue((String)"union class test not correct", (boolean)a.isUnionClass());
                31.assertTrue((String)"complement class test not correct", (!a.isComplementClass() ? 1 : 0) != 0);
                31.assertTrue((String)"restriction test not correct", (!a.isRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntClass.isComplementClass", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                ComplementClass a = m.createComplementClass("http://jena.hpl.hp.com/testing/ontology#A", (Resource)b);
                32.assertTrue((String)"enumerated class test not correct", (!a.isEnumeratedClass() ? 1 : 0) != 0);
                32.assertTrue((String)"intersection class test not correct", (!a.isIntersectionClass() ? 1 : 0) != 0);
                32.assertTrue((String)"union class test not correct", (!a.isUnionClass() ? 1 : 0) != 0);
                32.assertTrue((String)"complement class test not correct", (boolean)a.isComplementClass());
                32.assertTrue((String)"restriction test not correct", (!a.isRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntClass.isRestriction", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Restriction a = m.createRestriction(null);
                33.assertTrue((String)"enumerated class test not correct", (this.m_owlLiteLang || !a.isEnumeratedClass() ? 1 : 0) != 0);
                33.assertTrue((String)"intersection class test not correct", (!a.isIntersectionClass() ? 1 : 0) != 0);
                33.assertTrue((String)"union class test not correct", (this.m_owlLiteLang || !a.isUnionClass() ? 1 : 0) != 0);
                33.assertTrue((String)"complement class test not correct", (this.m_owlLiteLang || !a.isComplementClass() ? 1 : 0) != 0);
                33.assertTrue((String)"restriction test not correct", (boolean)a.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.toEnumeratedClass", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass a = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                34.assertTrue((String)"enumerated class test not correct", (!a.isEnumeratedClass() ? 1 : 0) != 0);
                34.assertTrue((String)"intersection class test not correct", (!a.isIntersectionClass() ? 1 : 0) != 0);
                34.assertTrue((String)"union class test not correct", (!a.isUnionClass() ? 1 : 0) != 0);
                34.assertTrue((String)"complement class test not correct", (!a.isComplementClass() ? 1 : 0) != 0);
                34.assertTrue((String)"restriction test not correct", (!a.isRestriction() ? 1 : 0) != 0);
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual x = m.createIndividual("http://jena.hpl.hp.com/testing/ontology#x", (Resource)b);
                Individual y = m.createIndividual("http://jena.hpl.hp.com/testing/ontology#y", (Resource)b);
                a = a.convertToEnumeratedClass(m.createList(new RDFNode[]{x, y}));
                34.assertTrue((String)"enumerated class test not correct", (boolean)a.isEnumeratedClass());
                34.assertTrue((String)"intersection class test not correct", (!a.isIntersectionClass() ? 1 : 0) != 0);
                34.assertTrue((String)"union class test not correct", (!a.isUnionClass() ? 1 : 0) != 0);
                34.assertTrue((String)"complement class test not correct", (!a.isComplementClass() ? 1 : 0) != 0);
                34.assertTrue((String)"restriction test not correct", (!a.isRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntClass.toIntersectionClass", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass a = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                35.assertTrue((String)"enumerated class test not correct", (this.m_owlLiteLang || !a.isEnumeratedClass() ? 1 : 0) != 0);
                35.assertTrue((String)"intersection class test not correct", (!a.isIntersectionClass() ? 1 : 0) != 0);
                35.assertTrue((String)"union class test not correct", (this.m_owlLiteLang || !a.isUnionClass() ? 1 : 0) != 0);
                35.assertTrue((String)"complement class test not correct", (this.m_owlLiteLang || !a.isComplementClass() ? 1 : 0) != 0);
                35.assertTrue((String)"restriction test not correct", (!a.isRestriction() ? 1 : 0) != 0);
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                a = a.convertToIntersectionClass(m.createList(new RDFNode[]{b, c}));
                35.assertTrue((String)"enumerated class test not correct", (this.m_owlLiteLang || !a.isEnumeratedClass() ? 1 : 0) != 0);
                35.assertTrue((String)"intersection class test not correct", (boolean)a.isIntersectionClass());
                35.assertTrue((String)"union class test not correct", (this.m_owlLiteLang || !a.isUnionClass() ? 1 : 0) != 0);
                35.assertTrue((String)"complement class test not correct", (this.m_owlLiteLang || !a.isComplementClass() ? 1 : 0) != 0);
                35.assertTrue((String)"restriction test not correct", (!a.isRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntClass.toUnionClass", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass a = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                36.assertTrue((String)"enumerated class test not correct", (!a.isEnumeratedClass() ? 1 : 0) != 0);
                36.assertTrue((String)"intersection class test not correct", (!a.isIntersectionClass() ? 1 : 0) != 0);
                36.assertTrue((String)"union class test not correct", (!a.isUnionClass() ? 1 : 0) != 0);
                36.assertTrue((String)"complement class test not correct", (!a.isComplementClass() ? 1 : 0) != 0);
                36.assertTrue((String)"restriction test not correct", (!a.isRestriction() ? 1 : 0) != 0);
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                a = a.convertToUnionClass(m.createList(new RDFNode[]{b, c}));
                36.assertTrue((String)"enumerated class test not correct", (this.m_owlLiteLang || !a.isEnumeratedClass() ? 1 : 0) != 0);
                36.assertTrue((String)"intersection class test not correct", (!a.isIntersectionClass() ? 1 : 0) != 0);
                36.assertTrue((String)"union class test not correct", (this.m_owlLiteLang || a.isUnionClass() ? 1 : 0) != 0);
                36.assertTrue((String)"complement class test not correct", (this.m_owlLiteLang || !a.isComplementClass() ? 1 : 0) != 0);
                36.assertTrue((String)"restriction test not correct", (!a.isRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntClass.toComplementClass", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass a = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                37.assertTrue((String)"enumerated class test not correct", (!a.isEnumeratedClass() ? 1 : 0) != 0);
                37.assertTrue((String)"intersection class test not correct", (!a.isIntersectionClass() ? 1 : 0) != 0);
                37.assertTrue((String)"union class test not correct", (!a.isUnionClass() ? 1 : 0) != 0);
                37.assertTrue((String)"complement class test not correct", (!a.isComplementClass() ? 1 : 0) != 0);
                37.assertTrue((String)"restriction test not correct", (!a.isRestriction() ? 1 : 0) != 0);
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                a = a.convertToComplementClass((Resource)b);
                37.assertTrue((String)"enumerated class test not correct", (this.m_owlLiteLang || !a.isEnumeratedClass() ? 1 : 0) != 0);
                37.assertTrue((String)"intersection class test not correct", (!a.isIntersectionClass() ? 1 : 0) != 0);
                37.assertTrue((String)"union class test not correct", (this.m_owlLiteLang || !a.isUnionClass() ? 1 : 0) != 0);
                37.assertTrue((String)"complement class test not correct", (this.m_owlLiteLang || a.isComplementClass() ? 1 : 0) != 0);
                37.assertTrue((String)"restriction test not correct", (!a.isRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntClass.toRestriction", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass a = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                38.assertTrue((String)"enumerated class test not correct", (this.m_owlLiteLang || !a.isEnumeratedClass() ? 1 : 0) != 0);
                38.assertTrue((String)"intersection class test not correct", (!a.isIntersectionClass() ? 1 : 0) != 0);
                38.assertTrue((String)"union class test not correct", (this.m_owlLiteLang || !a.isUnionClass() ? 1 : 0) != 0);
                38.assertTrue((String)"complement class test not correct", (this.m_owlLiteLang || !a.isComplementClass() ? 1 : 0) != 0);
                38.assertTrue((String)"restriction test not correct", (!a.isRestriction() ? 1 : 0) != 0);
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                a = a.convertToRestriction((Property)p);
                38.assertTrue((String)"enumerated class test not correct", (this.m_owlLiteLang || !a.isEnumeratedClass() ? 1 : 0) != 0);
                38.assertTrue((String)"intersection class test not correct", (!a.isIntersectionClass() ? 1 : 0) != 0);
                38.assertTrue((String)"union class test not correct", (this.m_owlLiteLang || !a.isUnionClass() ? 1 : 0) != 0);
                38.assertTrue((String)"complement class test not correct", (this.m_owlLiteLang || !a.isComplementClass() ? 1 : 0) != 0);
                38.assertTrue((String)"restriction test not correct", (boolean)a.isRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.isAllValuesFrom", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                AllValuesFromRestriction a = m.createAllValuesFromRestriction(null, (Property)p, (Resource)b);
                39.assertTrue((String)"all values from test not correct", (boolean)a.isAllValuesFromRestriction());
                39.assertTrue((String)"some values from test not correct", (!a.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                39.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !a.isHasValueRestriction() ? 1 : 0) != 0);
                39.assertTrue((String)"cardinality test not correct", (!a.isCardinalityRestriction() ? 1 : 0) != 0);
                39.assertTrue((String)"min cardinality test not correct", (!a.isMinCardinalityRestriction() ? 1 : 0) != 0);
                39.assertTrue((String)"max cardinality test not correct", (!a.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.isSomeValuesFrom", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                SomeValuesFromRestriction a = m.createSomeValuesFromRestriction(null, (Property)p, (Resource)b);
                40.assertTrue((String)"all values from test not correct", (!a.isAllValuesFromRestriction() ? 1 : 0) != 0);
                40.assertTrue((String)"some values from test not correct", (boolean)a.isSomeValuesFromRestriction());
                40.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !a.isHasValueRestriction() ? 1 : 0) != 0);
                40.assertTrue((String)"cardinality test not correct", (!a.isCardinalityRestriction() ? 1 : 0) != 0);
                40.assertTrue((String)"min cardinality test not correct", (!a.isMinCardinalityRestriction() ? 1 : 0) != 0);
                40.assertTrue((String)"max cardinality test not correct", (!a.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.isHasValue", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual x = m.createIndividual((Resource)b);
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                HasValueRestriction a = m.createHasValueRestriction(null, (Property)p, (RDFNode)x);
                41.assertTrue((String)"all values from test not correct", (!a.isAllValuesFromRestriction() ? 1 : 0) != 0);
                41.assertTrue((String)"some values from test not correct", (!a.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                41.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || a.isHasValueRestriction() ? 1 : 0) != 0);
                41.assertTrue((String)"cardinality test not correct", (!a.isCardinalityRestriction() ? 1 : 0) != 0);
                41.assertTrue((String)"min cardinality test not correct", (!a.isMinCardinalityRestriction() ? 1 : 0) != 0);
                41.assertTrue((String)"max cardinality test not correct", (!a.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.isCardinality", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                CardinalityRestriction a = m.createCardinalityRestriction(null, (Property)p, 3);
                42.assertTrue((String)"all values from test not correct", (!a.isAllValuesFromRestriction() ? 1 : 0) != 0);
                42.assertTrue((String)"some values from test not correct", (!a.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                42.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !a.isHasValueRestriction() ? 1 : 0) != 0);
                42.assertTrue((String)"cardinality test not correct", (boolean)a.isCardinalityRestriction());
                42.assertTrue((String)"min cardinality test not correct", (!a.isMinCardinalityRestriction() ? 1 : 0) != 0);
                42.assertTrue((String)"max cardinality test not correct", (!a.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.isMinCardinality", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                MinCardinalityRestriction a = m.createMinCardinalityRestriction(null, (Property)p, 1);
                43.assertTrue((String)"all values from test not correct", (!a.isAllValuesFromRestriction() ? 1 : 0) != 0);
                43.assertTrue((String)"some values from test not correct", (!a.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                43.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !a.isHasValueRestriction() ? 1 : 0) != 0);
                43.assertTrue((String)"cardinality test not correct", (!a.isCardinalityRestriction() ? 1 : 0) != 0);
                43.assertTrue((String)"min cardinality test not correct", (boolean)a.isMinCardinalityRestriction());
                43.assertTrue((String)"max cardinality test not correct", (!a.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.isMaxCardinality", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                MaxCardinalityRestriction a = m.createMaxCardinalityRestriction(null, (Property)p, 5);
                44.assertTrue((String)"all values from test not correct", (!a.isAllValuesFromRestriction() ? 1 : 0) != 0);
                44.assertTrue((String)"some values from test not correct", (!a.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                44.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !a.isHasValueRestriction() ? 1 : 0) != 0);
                44.assertTrue((String)"cardinality test not correct", (!a.isCardinalityRestriction() ? 1 : 0) != 0);
                44.assertTrue((String)"min cardinality test not correct", (!a.isMinCardinalityRestriction() ? 1 : 0) != 0);
                44.assertTrue((String)"max cardinality test not correct", (boolean)a.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.convertToAllValuesFrom", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction a = m.createRestriction((Property)p);
                45.assertTrue((String)"all values from test not correct", (!a.isAllValuesFromRestriction() ? 1 : 0) != 0);
                45.assertTrue((String)"some values from test not correct", (!a.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                45.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !a.isHasValueRestriction() ? 1 : 0) != 0);
                45.assertTrue((String)"cardinality test not correct", (!a.isCardinalityRestriction() ? 1 : 0) != 0);
                45.assertTrue((String)"min cardinality test not correct", (!a.isMinCardinalityRestriction() ? 1 : 0) != 0);
                45.assertTrue((String)"max cardinality test not correct", (!a.isMaxCardinalityRestriction() ? 1 : 0) != 0);
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                a = a.convertToAllValuesFromRestriction((Resource)b);
                45.assertTrue((String)"all values from test not correct", (boolean)a.isAllValuesFromRestriction());
                45.assertTrue((String)"some values from test not correct", (!a.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                45.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !a.isHasValueRestriction() ? 1 : 0) != 0);
                45.assertTrue((String)"cardinality test not correct", (!a.isCardinalityRestriction() ? 1 : 0) != 0);
                45.assertTrue((String)"min cardinality test not correct", (!a.isMinCardinalityRestriction() ? 1 : 0) != 0);
                45.assertTrue((String)"max cardinality test not correct", (!a.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.convertToSomeValuesFrom", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction a = m.createRestriction((Property)p);
                46.assertTrue((String)"all values from test not correct", (!a.isAllValuesFromRestriction() ? 1 : 0) != 0);
                46.assertTrue((String)"some values from test not correct", (!a.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                46.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !a.isHasValueRestriction() ? 1 : 0) != 0);
                46.assertTrue((String)"cardinality test not correct", (!a.isCardinalityRestriction() ? 1 : 0) != 0);
                46.assertTrue((String)"min cardinality test not correct", (!a.isMinCardinalityRestriction() ? 1 : 0) != 0);
                46.assertTrue((String)"max cardinality test not correct", (!a.isMaxCardinalityRestriction() ? 1 : 0) != 0);
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                a = a.convertToSomeValuesFromRestriction((Resource)b);
                46.assertTrue((String)"all values from test not correct", (!a.isAllValuesFromRestriction() ? 1 : 0) != 0);
                46.assertTrue((String)"some values from test not correct", (boolean)a.isSomeValuesFromRestriction());
                46.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !a.isHasValueRestriction() ? 1 : 0) != 0);
                46.assertTrue((String)"cardinality test not correct", (!a.isCardinalityRestriction() ? 1 : 0) != 0);
                46.assertTrue((String)"min cardinality test not correct", (!a.isMinCardinalityRestriction() ? 1 : 0) != 0);
                46.assertTrue((String)"max cardinality test not correct", (!a.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.convertToHasValue", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction a = m.createRestriction((Property)p);
                47.assertTrue((String)"all values from test not correct", (!a.isAllValuesFromRestriction() ? 1 : 0) != 0);
                47.assertTrue((String)"some values from test not correct", (!a.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                47.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !a.isHasValueRestriction() ? 1 : 0) != 0);
                47.assertTrue((String)"cardinality test not correct", (!a.isCardinalityRestriction() ? 1 : 0) != 0);
                47.assertTrue((String)"min cardinality test not correct", (!a.isMinCardinalityRestriction() ? 1 : 0) != 0);
                47.assertTrue((String)"max cardinality test not correct", (!a.isMaxCardinalityRestriction() ? 1 : 0) != 0);
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual x = m.createIndividual((Resource)b);
                a = a.convertToHasValueRestriction((RDFNode)x);
                47.assertTrue((String)"all values from test not correct", (!a.isAllValuesFromRestriction() ? 1 : 0) != 0);
                47.assertTrue((String)"some values from test not correct", (!a.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                47.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || a.isHasValueRestriction() ? 1 : 0) != 0);
                47.assertTrue((String)"cardinality test not correct", (!a.isCardinalityRestriction() ? 1 : 0) != 0);
                47.assertTrue((String)"min cardinality test not correct", (!a.isMinCardinalityRestriction() ? 1 : 0) != 0);
                47.assertTrue((String)"max cardinality test not correct", (!a.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.convertCardinality", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction a = m.createRestriction((Property)p);
                48.assertTrue((String)"all values from test not correct", (!a.isAllValuesFromRestriction() ? 1 : 0) != 0);
                48.assertTrue((String)"some values from test not correct", (!a.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                48.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !a.isHasValueRestriction() ? 1 : 0) != 0);
                48.assertTrue((String)"cardinality test not correct", (!a.isCardinalityRestriction() ? 1 : 0) != 0);
                48.assertTrue((String)"min cardinality test not correct", (!a.isMinCardinalityRestriction() ? 1 : 0) != 0);
                48.assertTrue((String)"max cardinality test not correct", (!a.isMaxCardinalityRestriction() ? 1 : 0) != 0);
                a = a.convertToCardinalityRestriction(3);
                48.assertTrue((String)"all values from test not correct", (!a.isAllValuesFromRestriction() ? 1 : 0) != 0);
                48.assertTrue((String)"some values from test not correct", (!a.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                48.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !a.isHasValueRestriction() ? 1 : 0) != 0);
                48.assertTrue((String)"cardinality test not correct", (boolean)a.isCardinalityRestriction());
                48.assertTrue((String)"min cardinality test not correct", (!a.isMinCardinalityRestriction() ? 1 : 0) != 0);
                48.assertTrue((String)"max cardinality test not correct", (!a.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.convertMinCardinality", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction a = m.createRestriction((Property)p);
                49.assertTrue((String)"all values from test not correct", (!a.isAllValuesFromRestriction() ? 1 : 0) != 0);
                49.assertTrue((String)"some values from test not correct", (!a.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                49.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !a.isHasValueRestriction() ? 1 : 0) != 0);
                49.assertTrue((String)"cardinality test not correct", (!a.isCardinalityRestriction() ? 1 : 0) != 0);
                49.assertTrue((String)"min cardinality test not correct", (!a.isMinCardinalityRestriction() ? 1 : 0) != 0);
                49.assertTrue((String)"max cardinality test not correct", (!a.isMaxCardinalityRestriction() ? 1 : 0) != 0);
                a = a.convertToMinCardinalityRestriction(3);
                49.assertTrue((String)"all values from test not correct", (!a.isAllValuesFromRestriction() ? 1 : 0) != 0);
                49.assertTrue((String)"some values from test not correct", (!a.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                49.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !a.isHasValueRestriction() ? 1 : 0) != 0);
                49.assertTrue((String)"cardinality test not correct", (!a.isCardinalityRestriction() ? 1 : 0) != 0);
                49.assertTrue((String)"min cardinality test not correct", (boolean)a.isMinCardinalityRestriction());
                49.assertTrue((String)"max cardinality test not correct", (!a.isMaxCardinalityRestriction() ? 1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("Restriction.convertMaxCardinality", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction a = m.createRestriction((Property)p);
                50.assertTrue((String)"all values from test not correct", (!a.isAllValuesFromRestriction() ? 1 : 0) != 0);
                50.assertTrue((String)"some values from test not correct", (!a.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                50.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !a.isHasValueRestriction() ? 1 : 0) != 0);
                50.assertTrue((String)"cardinality test not correct", (!a.isCardinalityRestriction() ? 1 : 0) != 0);
                50.assertTrue((String)"min cardinality test not correct", (!a.isMinCardinalityRestriction() ? 1 : 0) != 0);
                50.assertTrue((String)"max cardinality test not correct", (!a.isMaxCardinalityRestriction() ? 1 : 0) != 0);
                a = a.convertToMaxCardinalityRestriction(3);
                50.assertTrue((String)"all values from test not correct", (!a.isAllValuesFromRestriction() ? 1 : 0) != 0);
                50.assertTrue((String)"some values from test not correct", (!a.isSomeValuesFromRestriction() ? 1 : 0) != 0);
                50.assertTrue((String)"has value test not correct", (this.m_owlLiteLang || !a.isHasValueRestriction() ? 1 : 0) != 0);
                50.assertTrue((String)"cardinality test not correct", (!a.isCardinalityRestriction() ? 1 : 0) != 0);
                50.assertTrue((String)"min cardinality test not correct", (!a.isMinCardinalityRestriction() ? 1 : 0) != 0);
                50.assertTrue((String)"max cardinality test not correct", (boolean)a.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.listInstances", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual a0 = m.createIndividual((Resource)A);
                Individual a1 = m.createIndividual("http://jena.hpl.hp.com/testing/ontology#a1", (Resource)A);
                Individual b0 = m.createIndividual((Resource)B);
                m.createIndividual("http://jena.hpl.hp.com/testing/ontology#b1", (Resource)B);
                b0.addRDFType((Resource)A);
                this.iteratorTest((Iterator)A.listInstances(), new Object[]{a0, a1, b0});
            }
        }, new OntTestBase.OntTestCase("OntClass.listDefinedProperties", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass C = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                OntProperty p = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntProperty q = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntProperty r = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#r");
                OntProperty s = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#s");
                p.setDomain((Resource)A);
                q.setDomain((Resource)A);
                s.setDomain((Resource)C);
                if (this.m_rdfsLang) {
                    this.iteratorTest((Iterator)A.listDeclaredProperties(), new Object[]{p, q, r});
                } else {
                    Restriction r0 = m.createRestriction((Property)r);
                    C.addSuperClass((Resource)r0);
                    this.iteratorTest((Iterator)A.listDeclaredProperties(), new Object[]{p, q, r});
                    this.iteratorTest((Iterator)C.listDeclaredProperties(), new Object[]{s, r});
                    this.iteratorTest((Iterator)r0.listDeclaredProperties(), new Object[]{r});
                }
            }
        }, new OntTestBase.OntTestCase("OntClass.listDefinedProperties.notAll", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass C = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                C.addSuperClass((Resource)A);
                OntProperty p = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntProperty q = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntProperty s = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#s");
                p.setDomain((Resource)A);
                q.setDomain((Resource)A);
                s.setDomain((Resource)C);
                this.iteratorTest((Iterator)C.listDeclaredProperties(false), new Object[]{p, q, s});
                this.iteratorTest((Iterator)C.listDeclaredProperties(true), new Object[]{s});
                53.assertTrue((String)"declared property should be an ont prop", (boolean)(C.listDeclaredProperties(true).next() instanceof OntProperty));
                53.assertTrue((String)"declared property should be an ont prop", (boolean)(C.listDeclaredProperties(false).next() instanceof OntProperty));
            }
        }, new OntTestBase.OntTestCase("DataRange.oneOf", true, false, false, false){

            public void ontTest(OntModel m) throws Exception {
                Literal x = m.createTypedLiteral(42);
                Literal y = m.createTypedLiteral(true);
                Literal z = m.createTypedLiteral("life");
                RDFList lits = m.createList(new RDFNode[]{x, y});
                DataRange d0 = m.createDataRange(lits);
                54.assertTrue((String)"datarange should contain x", (boolean)d0.hasOneOf(x));
                54.assertTrue((String)"datarange should contain y", (boolean)d0.hasOneOf(y));
                54.assertFalse((String)"datarange should not contain z", (boolean)d0.hasOneOf(z));
                d0.removeOneOf(z);
                54.assertTrue((String)"datarange should contain x", (boolean)d0.hasOneOf(x));
                54.assertTrue((String)"datarange should contain y", (boolean)d0.hasOneOf(y));
                54.assertFalse((String)"datarange should not contain z", (boolean)d0.hasOneOf(z));
                d0.removeOneOf(x);
                54.assertFalse((String)"datarange should not contain x", (boolean)d0.hasOneOf(x));
                54.assertTrue((String)"datarange should contain y", (boolean)d0.hasOneOf(y));
                54.assertFalse((String)"datarange should not contain z", (boolean)d0.hasOneOf(z));
                d0.addOneOf(z);
                54.assertEquals((String)"datarange should be size 2", (int)2, (int)d0.getOneOf().size());
                this.iteratorTest((Iterator)d0.listOneOf(), new Object[]{y, z});
                d0.setOneOf(m.createList(new RDFNode[]{x}));
                this.iteratorTest((Iterator)d0.listOneOf(), new Object[]{x});
            }
        }};
    }
}

