/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.test.JenaTestBase;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class GraphTestBase
extends JenaTestBase {
    protected static int bnc = 1000;

    public GraphTestBase(String name) {
        super(name);
    }

    public static Node node(String x) {
        return Node.create((String)x);
    }

    public static Set iteratorToSet(Iterator it) {
        return IteratorCollection.iteratorToSet((Iterator)it);
    }

    public static List iteratorToList(Iterator it) {
        return IteratorCollection.iteratorToList((Iterator)it);
    }

    public Set nodeSet(String nodes) {
        Set result = CollectionFactory.createHashedSet();
        StringTokenizer st = new StringTokenizer(nodes);
        while (st.hasMoreTokens()) {
            result.add(GraphTestBase.node(st.nextToken()));
        }
        return result;
    }

    public Set arrayToSet(Object[] A) {
        return CollectionFactory.createHashedSet(Arrays.asList(A));
    }

    public static Triple triple(String fact) {
        return Triple.create((String)fact);
    }

    public static Triple triple(PrefixMapping pm, String fact) {
        return Triple.create((PrefixMapping)pm, (String)fact);
    }

    public static Triple[] tripleArray(String facts) {
        ArrayList<Triple> al = new ArrayList<Triple>();
        StringTokenizer semis = new StringTokenizer(facts, ";");
        while (semis.hasMoreTokens()) {
            al.add(GraphTestBase.triple(PrefixMapping.Extended, semis.nextToken()));
        }
        return al.toArray(new Triple[al.size()]);
    }

    public static Set tripleSet(String facts) {
        HashSet<Triple> result = new HashSet<Triple>();
        StringTokenizer semis = new StringTokenizer(facts, ";");
        while (semis.hasMoreTokens()) {
            result.add(GraphTestBase.triple(semis.nextToken()));
        }
        return result;
    }

    public static List nodeList(String items) {
        ArrayList<Node> nl = new ArrayList<Node>();
        StringTokenizer nodes = new StringTokenizer(items);
        while (nodes.hasMoreTokens()) {
            nl.add(GraphTestBase.node(nodes.nextToken()));
        }
        return nl;
    }

    public static Node[] nodeArray(String items) {
        List nl = GraphTestBase.nodeList(items);
        return nl.toArray(new Node[nl.size()]);
    }

    public static Graph graphAdd(Graph g, String s) {
        StringTokenizer semis = new StringTokenizer(s, ";");
        while (semis.hasMoreTokens()) {
            g.add(GraphTestBase.triple(PrefixMapping.Extended, semis.nextToken()));
        }
        return g;
    }

    public static Graph newGraph() {
        Graph result = Factory.createGraphMem();
        result.getPrefixMapping().setNsPrefixes(PrefixMapping.Extended);
        return result;
    }

    public static Graph graphWith(String s) {
        return GraphTestBase.graphAdd(GraphTestBase.newGraph(), s);
    }

    public static void assertEqualsTemplate(String title, Graph g, String template) {
        GraphTestBase.assertIsomorphic(title, GraphTestBase.graphWith(template), g);
    }

    public static void assertIsomorphic(String title, Graph expected, Graph got) {
        if (!expected.isIsomorphicWith(got)) {
            Map map = CollectionFactory.createHashedMap();
            GraphTestBase.fail((String)(title + ": wanted " + GraphTestBase.nice(expected, map) + "\nbut got " + GraphTestBase.nice(got, map)));
        }
    }

    public static String nice(Graph g, Map bnodes) {
        StringBuffer b = new StringBuffer(g.size() * 100);
        ExtendedIterator it = GraphUtil.findAll((Graph)g);
        while (it.hasNext()) {
            GraphTestBase.niceTriple(b, bnodes, (Triple)it.next());
        }
        return b.toString();
    }

    protected static void niceTriple(StringBuffer b, Map bnodes, Triple t) {
        b.append("\n    ");
        GraphTestBase.appendNode(b, bnodes, t.getSubject());
        GraphTestBase.appendNode(b, bnodes, t.getPredicate());
        GraphTestBase.appendNode(b, bnodes, t.getObject());
    }

    protected static void appendNode(StringBuffer b, Map bnodes, Node n) {
        b.append(' ');
        if (n.isBlank()) {
            Object already = bnodes.get(n);
            if (already == null) {
                already = "_b" + bnc++;
                bnodes.put(n, already);
            }
            b.append(already);
        } else {
            b.append(GraphTestBase.nice(n));
        }
    }

    protected static String nice(Node n) {
        return n.toString(PrefixMapping.Extended, true);
    }

    public static void assertIsomorphic(Graph expected, Graph got) {
        GraphTestBase.assertIsomorphic("graphs must be isomorphic", expected, got);
    }

    public static void assertContains(String name, String s, Graph g) {
        GraphTestBase.assertTrue((String)(name + " must contain " + s), (boolean)g.contains(GraphTestBase.triple(s)));
    }

    public static void assertContainsAll(String name, Graph g, String s) {
        StringTokenizer semis = new StringTokenizer(s, ";");
        while (semis.hasMoreTokens()) {
            GraphTestBase.assertContains(name, semis.nextToken(), g);
        }
    }

    public static void assertOmits(String name, Graph g, String s) {
        GraphTestBase.assertFalse((String)(name + " must not contain " + s), (boolean)g.contains(GraphTestBase.triple(s)));
    }

    public static void assertOmitsAll(String name, Graph g, String s) {
        StringTokenizer semis = new StringTokenizer(s, ";");
        while (semis.hasMoreTokens()) {
            GraphTestBase.assertOmits(name, g, semis.nextToken());
        }
    }

    public static boolean contains(Graph g, String fact) {
        return g.contains(GraphTestBase.triple(fact));
    }

    public void testContains(Graph g, Triple[] triples) {
        for (int i = 0; i < triples.length; ++i) {
            GraphTestBase.assertTrue((String)("contains " + triples[i]), (boolean)g.contains(triples[i]));
        }
    }

    public void testContains(Graph g, List triples) {
        for (int i = 0; i < triples.size(); ++i) {
            GraphTestBase.assertTrue((boolean)g.contains((Triple)triples.get(i)));
        }
    }

    public void testContains(Graph g, Iterator it) {
        while (it.hasNext()) {
            GraphTestBase.assertTrue((boolean)g.contains((Triple)it.next()));
        }
    }

    public void testContains(Graph g, Graph other) {
        this.testContains(g, (Iterator)GraphUtil.findAll((Graph)other));
    }

    public void testOmits(Graph g, Triple[] triples) {
        for (int i = 0; i < triples.length; ++i) {
            GraphTestBase.assertFalse((String)"", (boolean)g.contains(triples[i]));
        }
    }

    public void testOmits(Graph g, List triples) {
        for (int i = 0; i < triples.size(); ++i) {
            GraphTestBase.assertFalse((String)"", (boolean)g.contains((Triple)triples.get(i)));
        }
    }

    public void testOmits(Graph g, Iterator it) {
        while (it.hasNext()) {
            GraphTestBase.assertFalse((String)"", (boolean)g.contains((Triple)it.next()));
        }
    }

    public void testOmits(Graph g, Graph other) {
        this.testOmits(g, (Iterator)GraphUtil.findAll((Graph)other));
    }

    public static Graph getGraph(Object wrap, Class graphClass, ReificationStyle style) {
        try {
            Constructor cons = GraphTestBase.getConstructor(graphClass, new Class[]{ReificationStyle.class});
            if (cons != null) {
                return (Graph)cons.newInstance(style);
            }
            Constructor cons2 = GraphTestBase.getConstructor(graphClass, new Class[]{wrap.getClass(), ReificationStyle.class});
            if (cons2 != null) {
                return (Graph)cons2.newInstance(wrap, style);
            }
            throw new JenaException("no suitable graph constructor found for " + graphClass);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    protected static Graph getReificationTriples(final Reifier r) {
        return new GraphBase(){

            public ExtendedIterator graphBaseFind(TripleMatch m) {
                return r.find(m);
            }
        };
    }
}

