/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.impl.DriverRDB;
import com.hp.hpl.jena.db.impl.Driver_MySQL;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestTransactions
extends TestCase {
    ModelRDB model = null;
    Model dbProperties = null;
    IDBConnection conn = null;
    DriverRDB m_driver = null;

    public TestTransactions(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestTransactions.class);
    }

    protected void setUp() throws Exception {
        this.conn = TestConnection.makeAndCleanTestConnection();
        this.dbProperties = this.conn.getDatabaseProperties();
        this.model = ModelRDB.createModel((IDBConnection)this.conn);
        this.m_driver = new Driver_MySQL();
        this.m_driver.setConnection(this.conn);
    }

    protected void tearDown() throws Exception {
        this.model.close();
        this.model = null;
        this.conn.cleanDB();
        this.conn.close();
        this.conn = null;
    }

    private void addCommit(Statement stmt) {
        this.model.remove(stmt);
        this.model.begin();
        this.model.add(stmt);
        this.model.commit();
        TestTransactions.assertTrue((boolean)this.model.contains(stmt));
    }

    private void addAbort(Statement stmt) {
        this.model.remove(stmt);
        this.model.begin();
        this.model.add(stmt);
        this.model.abort();
        TestTransactions.assertTrue((!this.model.contains(stmt) ? 1 : 0) != 0);
    }

    public void testAddCommitURI() {
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Resource o = this.model.createResource("test#object");
        this.addCommit(this.model.createStatement(s, p, (RDFNode)o));
    }

    public void testAddAbortURI() {
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Resource o = this.model.createResource("test#object");
        this.addAbort(this.model.createStatement(s, p, (RDFNode)o));
    }

    public void testAddCommitLiteral() {
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Literal l = this.model.createLiteral("testLiteral");
        this.addCommit(this.model.createStatement(s, p, (RDFNode)l));
    }

    public void testAddCommitHugeLiteral() {
        String base = "This is a huge string that repeats. \u00ce\u00b1\u00ce\u00b2\u00ce\u00b3\u00ce\u00b4\u00ce\u00b5 \u00d7?\u00d7\u2018\u00d7\u2019\u00d7\u201c\u00d7\u201d \u00d8\u00a7\u00d8\u00a8\u00d8\u00a9\u00d8\u00aa\u00d8\u00ab";
        StringBuffer buffer = new StringBuffer(4096);
        while (buffer.length() < 4000) {
            buffer.append(base);
        }
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Literal l = this.model.createLiteral(buffer.toString());
        this.addCommit(this.model.createStatement(s, p, (RDFNode)l));
    }

    public void testAddAbortHugeLiteral() {
        String base = "This is a huge string that repeats. \u00ce\u00b1\u00ce\u00b2\u00ce\u00b3\u00ce\u00b4\u00ce\u00b5 \u00d7?\u00d7\u2018\u00d7\u2019\u00d7\u201c\u00d7\u201d \u00d8\u00a7\u00d8\u00a8\u00d8\u00a9\u00d8\u00aa\u00d8\u00ab";
        StringBuffer buffer = new StringBuffer(4096);
        while (buffer.length() < 4000) {
            buffer.append(base);
        }
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Literal l = this.model.createLiteral(buffer.toString());
        this.addAbort(this.model.createStatement(s, p, (RDFNode)l));
    }

    public void testAddCommitDatatype() {
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Literal l = this.model.createTypedLiteral("stringType");
        this.addCommit(this.model.createStatement(s, p, (RDFNode)l));
    }

    public void testAddAbortDatatype() {
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Literal l = this.model.createTypedLiteral("stringType");
        this.addAbort(this.model.createStatement(s, p, (RDFNode)l));
    }

    public void testAddAbortHugeDatatype() {
        String base = "This is a huge string that repeats. \u00ce\u00b1\u00ce\u00b2\u00ce\u00b3\u00ce\u00b4\u00ce\u00b5 \u00d7?\u00d7\u2018\u00d7\u2019\u00d7\u201c\u00d7\u201d \u00d8\u00a7\u00d8\u00a8\u00d8\u00a9\u00d8\u00aa\u00d8\u00ab";
        StringBuffer buffer = new StringBuffer(4096);
        while (buffer.length() < 4000) {
            buffer.append(base);
        }
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Literal l2 = this.model.createTypedLiteral(buffer.toString());
        this.addAbort(this.model.createStatement(s, p, (RDFNode)l2));
    }

    public void testAddCommitHugeDatatype() {
        String base = "This is a huge string that repeats. \u00ce\u00b1\u00ce\u00b2\u00ce\u00b3\u00ce\u00b4\u00ce\u00b5 \u00d7?\u00d7\u2018\u00d7\u2019\u00d7\u201c\u00d7\u201d \u00d8\u00a7\u00d8\u00a8\u00d8\u00a9\u00d8\u00aa\u00d8\u00ab";
        StringBuffer buffer = new StringBuffer(4096);
        while (buffer.length() < 4000) {
            buffer.append(base);
        }
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Literal l2 = this.model.createTypedLiteral(buffer.toString());
        this.addCommit(this.model.createStatement(s, p, (RDFNode)l2));
    }

    public void testAddCommitBNode() {
        Resource s = this.model.createResource();
        Property p = this.model.createProperty("test#predicate");
        Resource o = this.model.createResource();
        this.addCommit(this.model.createStatement(s, p, (RDFNode)o));
    }

    public void testAddAbortBNode() {
        Resource s = this.model.createResource();
        Property p = this.model.createProperty("test#predicate");
        Resource o = this.model.createResource();
        this.addAbort(this.model.createStatement(s, p, (RDFNode)o));
    }
}

