/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.DBConnection;
import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.test.TestPackage;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestRDQLOptions
extends TestCase {
    String qryCountSubjS2 = "SELECT * WHERE (<ex:s2>, ?p1, ?v), (?v, ?p2, ?o)USING ex FOR  <http://ex.org/> ";
    String qryCountObjS1 = "SELECT * WHERE (?s, ?p1, ?v), (?v, ?p2, <ex:o1>)USING ex FOR  <http://ex.org/> ";
    String qryCountObjS1O1 = "SELECT * WHERE (?v, <rdf:subject>, <ex:s1>), (?v, <rdf:object>, <http://ex.org/o1>)USING rdf FOR <http://www.w3.org/1999/02/22-rdf-syntax-ns#>, ex FOR <http://ex.org/>";
    IDBConnection conn = null;
    ModelRDB model = null;

    public TestRDQLOptions(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestRDQLOptions.class);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    private Statement crAssertedStmt(String subj, String pred, String obj) {
        Resource s = this.model.createResource("http://ex.org/" + subj);
        Property p = this.model.createProperty("http://ex.org/" + pred);
        Resource o = this.model.createResource("http://ex.org/" + obj);
        return this.crAssertedStmt(s, p, (RDFNode)o);
    }

    private Statement crAssertedStmt(Resource s, Property p, RDFNode o) {
        Statement stmt = this.model.createStatement(s, p, o);
        this.model.add(stmt);
        return stmt;
    }

    private Resource crReifiedStmt(String node, Statement stmt) {
        Resource n = this.model.createResource("http://ex.org/" + node);
        Resource s = stmt.getSubject();
        Property p = stmt.getPredicate();
        RDFNode o = stmt.getObject();
        this.crAssertedStmt(n, RDF.subject, (RDFNode)s);
        this.crAssertedStmt(n, RDF.predicate, (RDFNode)p);
        this.crAssertedStmt(n, RDF.object, o);
        this.crAssertedStmt(n, RDF.type, (RDFNode)RDF.Statement);
        return n;
    }

    private int countQuery(String qryString) {
        Query query = new Query(qryString);
        query.setSource((Model)this.model);
        QueryEngine qe = new QueryEngine(query);
        QueryResults results = qe.exec();
        int i = 0;
        while (results.hasNext()) {
            results.next();
            ++i;
        }
        return i;
    }

    private static void loadClass() {
        try {
            Class.forName(TestPackage.M_DBDRIVER_CLASS);
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    public static IDBConnection makeTestConnection() {
        TestRDQLOptions.loadClass();
        return new DBConnection(TestPackage.M_DB_URL, TestPackage.M_DB_USER, TestPackage.M_DB_PASSWD, TestPackage.M_DB);
    }

    public static IDBConnection makeAndCleanTestConnection() {
        DBConnection result;
        try {
            result = (DBConnection)TestRDQLOptions.makeTestConnection();
            result.cleanDB();
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        return result;
    }

    public void testMatches() throws Exception {
        Class.forName(TestPackage.M_DBDRIVER_CLASS);
        this.conn = TestRDQLOptions.makeAndCleanTestConnection();
        this.model = ModelRDB.createModel((IDBConnection)this.conn);
        IRDBDriver dbDriver = null;
        dbDriver = this.conn.getDriver();
        GraphRDB g = new GraphRDB(this.conn, null, null, 1, false);
        this.model = new ModelRDB(g);
        Statement a1 = this.crAssertedStmt("s1", "p1", "o1");
        Statement a2 = this.crAssertedStmt("s2", "p2", "s1");
        Resource r1 = this.crReifiedStmt("r1", a1);
        Resource r2 = this.crReifiedStmt("r2", a2);
        int cnt = this.countQuery(this.qryCountSubjS2);
        TestRDQLOptions.assertTrue((cnt == 1 ? 1 : 0) != 0);
        cnt = this.countQuery(this.qryCountObjS1);
        TestRDQLOptions.assertTrue((cnt == 3 ? 1 : 0) != 0);
        this.model.setQueryOnlyAsserted(true);
        cnt = this.countQuery(this.qryCountObjS1);
        TestRDQLOptions.assertTrue((cnt == 1 ? 1 : 0) != 0);
        this.model.setQueryOnlyReified(true);
        this.model.setQueryFullReified(true);
        cnt = this.countQuery(this.qryCountObjS1);
        TestRDQLOptions.assertTrue((cnt == 0 ? 1 : 0) != 0);
        cnt = this.countQuery(this.qryCountObjS1O1);
        TestRDQLOptions.assertTrue((cnt == 1 ? 1 : 0) != 0);
        this.model.setQueryFullReified(false);
        try {
            cnt = this.countQuery(this.qryCountObjS1O1);
            TestRDQLOptions.assertTrue((boolean)false);
        }
        catch (JenaException e) {
            TestRDQLOptions.assertTrue((boolean)true);
        }
    }
}

