/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.DBConnection;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.test.TestPackage;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.shared.JenaException;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestRDQLMatch
extends TestCase {
    String pfxQueryString = "SELECT * WHERE (?s, <ex:prop>, ?o) and ?o =~ /^hi/USING ex FOR  <http://example.org/> ";
    String sfxQueryString = "SELECT * WHERE (?s, <ex:prop>, ?o) and ?o =~ /there$/ USING ex FOR  <http://example.org/> ";
    String ipfxQueryString = "SELECT * WHERE (?s, <ex:prop>, ?o) and ?o =~ /^hi/iUSING ex FOR  <http://example.org/> ";
    String isfxQueryString = "SELECT * WHERE (?s, <ex:prop>, ?o) and ?o =~ /there$/i USING ex FOR  <http://example.org/> ";
    String epfxQueryString = "SELECT * WHERE (?s, <ex:prop>, ?o) and ?o =~ /^yo_their/ USING ex FOR  <http://example.org/> ";
    String unboundQueryString = "SELECT * WHERE (?s, ?p, ?o) and ?o =~ /hi/";
    String lobjQueryString = "SELECT * WHERE (?s, <ex:prop>, ?o) and ?o =~ /789obj/ USING ex FOR  <http://example.org/> ";
    String lsubjQueryString = "SELECT * WHERE (?s, <ex:prop>, ?o) and ?s =~ /789subj/ USING ex FOR  <http://example.org/> ";
    String lpredQueryString = "SELECT * WHERE (<ex:subj>, ?p, ?o) and ?p =~ /789pred/ USING ex FOR  <http://example.org/> ";

    public TestRDQLMatch(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestRDQLMatch.class);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    private static void loadClass() {
        try {
            Class.forName(TestPackage.M_DBDRIVER_CLASS);
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    public static IDBConnection makeTestConnection() {
        TestRDQLMatch.loadClass();
        return new DBConnection(TestPackage.M_DB_URL, TestPackage.M_DB_USER, TestPackage.M_DB_PASSWD, TestPackage.M_DB);
    }

    public static IDBConnection makeAndCleanTestConnection() {
        DBConnection result;
        try {
            result = (DBConnection)TestRDQLMatch.makeTestConnection();
            result.cleanDB();
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        return result;
    }

    public void testMatches() throws Exception {
        Class.forName(TestPackage.M_DBDRIVER_CLASS);
        IDBConnection conn = TestRDQLMatch.makeAndCleanTestConnection();
        ModelRDB model = ModelRDB.createModel((IDBConnection)conn);
        IRDBDriver dbDriver = null;
        dbDriver = conn.getDriver();
        Resource subj = ResourceFactory.createResource((String)"http://example.org/subj");
        Property pred = ResourceFactory.createProperty((String)"http://example.org/prop");
        Resource obj = ResourceFactory.createResource((String)"http://example.org/obj");
        Statement s1 = ResourceFactory.createStatement((Resource)subj, (Property)pred, (RDFNode)obj);
        Literal lit1 = ResourceFactory.createPlainLiteral((String)"hi there");
        Statement s2 = ResourceFactory.createStatement((Resource)subj, (Property)pred, (RDFNode)lit1);
        Literal lit2 = ResourceFactory.createPlainLiteral((String)"hi there again");
        Statement s3 = ResourceFactory.createStatement((Resource)subj, (Property)pred, (RDFNode)lit2);
        Literal lit3 = ResourceFactory.createPlainLiteral((String)"HI THERE");
        Statement s4 = ResourceFactory.createStatement((Resource)subj, (Property)pred, (RDFNode)lit3);
        Literal lit4 = ResourceFactory.createPlainLiteral((String)"HI THERE AGAIN");
        Statement s5 = ResourceFactory.createStatement((Resource)subj, (Property)pred, (RDFNode)lit4);
        Literal lit5 = ResourceFactory.createPlainLiteral((String)"yo_their");
        Statement s6 = ResourceFactory.createStatement((Resource)subj, (Property)pred, (RDFNode)lit5);
        Literal lit6 = ResourceFactory.createPlainLiteral((String)"yo their");
        Statement s7 = ResourceFactory.createStatement((Resource)subj, (Property)pred, (RDFNode)lit6);
        String sfx = "0123456789";
        String longURI = "http://example.org/long#";
        long longLen = dbDriver.getLongObjectLength();
        while ((long)longURI.length() < longLen) {
            longURI = longURI + sfx;
        }
        Resource subjLong = ResourceFactory.createResource((String)(longURI + "subj"));
        Property predLong = ResourceFactory.createProperty((String)(longURI + "pred"));
        Resource objLong = ResourceFactory.createResource((String)(longURI + "obj"));
        Literal litLong = ResourceFactory.createPlainLiteral((String)(longURI + "obj"));
        Statement s8 = ResourceFactory.createStatement((Resource)subjLong, (Property)pred, (RDFNode)objLong);
        Statement s9 = ResourceFactory.createStatement((Resource)subjLong, (Property)pred, (RDFNode)litLong);
        Statement s10 = ResourceFactory.createStatement((Resource)subj, (Property)predLong, (RDFNode)litLong);
        model.add(s1);
        model.add(s2);
        model.add(s3);
        model.add(s4);
        model.add(s5);
        model.add(s6);
        model.add(s7);
        model.add(s8);
        model.add(s9);
        model.add(s10);
        Query query = new Query(this.pfxQueryString);
        query.setSource((Model)model);
        QueryEngine qe = new QueryEngine(query);
        QueryResults results = qe.exec();
        int i = 0;
        while (results.hasNext()) {
            results.next();
            ++i;
        }
        TestRDQLMatch.assertTrue((i == 2 ? 1 : 0) != 0);
        query = new Query(this.ipfxQueryString);
        query.setSource((Model)model);
        qe = new QueryEngine(query);
        results = qe.exec();
        i = 0;
        while (results.hasNext()) {
            results.next();
            ++i;
        }
        TestRDQLMatch.assertTrue((i == 4 ? 1 : 0) != 0);
        query = new Query(this.sfxQueryString);
        query.setSource((Model)model);
        qe = new QueryEngine(query);
        results = qe.exec();
        i = 0;
        while (results.hasNext()) {
            results.next();
            ++i;
        }
        TestRDQLMatch.assertTrue((i == 1 ? 1 : 0) != 0);
        query = new Query(this.isfxQueryString);
        query.setSource((Model)model);
        qe = new QueryEngine(query);
        results = qe.exec();
        i = 0;
        while (results.hasNext()) {
            results.next();
            ++i;
        }
        TestRDQLMatch.assertTrue((i == 2 ? 1 : 0) != 0);
        query = new Query(this.epfxQueryString);
        query.setSource((Model)model);
        qe = new QueryEngine(query);
        results = qe.exec();
        i = 0;
        while (results.hasNext()) {
            results.next();
            ++i;
        }
        TestRDQLMatch.assertTrue((i == 1 ? 1 : 0) != 0);
        query = new Query(this.unboundQueryString);
        query.setSource((Model)model);
        qe = new QueryEngine(query);
        results = qe.exec();
        i = 0;
        while (results.hasNext()) {
            results.next();
            ++i;
        }
        TestRDQLMatch.assertTrue((i == 2 ? 1 : 0) != 0);
        query = new Query(this.lsubjQueryString);
        query.setSource((Model)model);
        qe = new QueryEngine(query);
        results = qe.exec();
        i = 0;
        while (results.hasNext()) {
            results.next();
            ++i;
        }
        TestRDQLMatch.assertTrue((i == 2 ? 1 : 0) != 0);
        query = new Query(this.lpredQueryString);
        query.setSource((Model)model);
        qe = new QueryEngine(query);
        results = qe.exec();
        i = 0;
        while (results.hasNext()) {
            results.next();
            ++i;
        }
        TestRDQLMatch.assertTrue((i == 1 ? 1 : 0) != 0);
        query = new Query(this.lobjQueryString);
        query.setSource((Model)model);
        qe = new QueryEngine(query);
        results = qe.exec();
        i = 0;
        while (results.hasNext()) {
            results.next();
            ++i;
        }
        TestRDQLMatch.assertTrue((i == 2 ? 1 : 0) != 0);
    }
}

