/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.assembler.assemblers.AssemblerGroup;
import com.hp.hpl.jena.assembler.exceptions.NoImplementationException;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.mem.GraphMemBase;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDFS;
import junit.framework.Assert;

public class TestAssemblerGroup
extends AssemblerTestBase {
    private Assembler mockAssembler = new AssemblerBase(){

        public Object open(Assembler a, Resource root, Mode mode) {
            return null;
        }
    };

    public TestAssemblerGroup(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        return AssemblerGroup.class;
    }

    public void testEmptyAssemblerGroup() {
        AssemblerGroup a = AssemblerGroup.create();
        TestAssemblerGroup.assertInstanceOf(AssemblerGroup.class, a);
        TestAssemblerGroup.assertEquals(null, (Object)a.assemblerFor(TestAssemblerGroup.resource("ja:Anything")));
        this.checkFailsType((Assembler)a, "rdf:Resource");
    }

    protected void checkFailsType(Assembler a, String type) {
        try {
            a.open(this.resourceInModel("x rdf:type " + type));
            TestAssemblerGroup.fail((String)"should trap missing implementation");
        }
        catch (NoImplementationException e) {
            TestAssemblerGroup.assertEquals((Object)TestAssemblerGroup.resource("x"), (Object)e.getRoot());
            TestAssemblerGroup.assertEquals((Object)JA.Object, (Object)e.getType());
            TestAssemblerGroup.assertNotNull((Object)e.getAssembler());
        }
    }

    public void testSingletonAssemblerGroup() {
        AssemblerGroup a = AssemblerGroup.create();
        TestAssemblerGroup.assertSame((Object)a, (Object)a.implementWith(JA.InfModel, Assembler.infModel));
        a.openModel(this.resourceInModel("x rdf:type ja:InfModel"));
        this.checkFailsType((Assembler)a, "js:DefaultModel");
    }

    public void testMultipleAssemblerGroup() {
        AssemblerGroup a = AssemblerGroup.create();
        TestAssemblerGroup.assertSame((Object)a, (Object)a.implementWith(JA.InfModel, Assembler.infModel));
        TestAssemblerGroup.assertSame((Object)a, (Object)a.implementWith(JA.MemoryModel, Assembler.memoryModel));
        TestAssemblerGroup.assertInstanceOf(InfModel.class, a.openModel(this.resourceInModel("x rdf:type ja:InfModel")));
        TestAssemblerGroup.assertFalse((boolean)(a.openModel(this.resourceInModel("y rdf:type ja:MemoryModel")) instanceof InfModel));
        this.checkFailsType((Assembler)a, "js:DefaultModel");
    }

    public void testImpliedType() {
        AssemblerGroup a = AssemblerGroup.create();
        Resource root = this.resourceInModel("x ja:reasoner y");
        Object expected = new Object();
        a.implementWith(JA.InfModel, (Assembler)new AssemblerTestBase.NamedObjectAssembler(TestAssemblerGroup.resource("x"), expected));
        TestAssemblerGroup.assertSame((Object)expected, (Object)a.open(root));
    }

    public void testBuiltinGroup() {
        AssemblerGroup g = Assembler.general;
        TestAssemblerGroup.assertInstanceOf(Model.class, g.open(this.resourceInModel("x rdf:type ja:DefaultModel")));
        TestAssemblerGroup.assertInstanceOf(InfModel.class, g.open(this.resourceInModel("x rdf:type ja:InfModel")));
        this.assertMemoryModel(g.open(this.resourceInModel("x rdf:type ja:MemoryModel")));
    }

    public void testAddingImplAddsSubclass() {
        final Model[] fullModel = new Model[1];
        AssemblerGroup.ExpandingAssemblerGroup g = new AssemblerGroup.ExpandingAssemblerGroup(){

            public void loadClasses(Model full) {
                fullModel[0] = full;
            }
        };
        Resource root = this.resourceInModel("root rdf:type typeA");
        Resource typeA = TestAssemblerGroup.resource("typeA");
        Resource typeB = TestAssemblerGroup.resource("typeB");
        g.implementWith(typeA, this.mockAssembler);
        g.implementWith(typeB, this.mockAssembler);
        g.open(root);
        TestAssemblerGroup.assertTrue((boolean)fullModel[0].contains(typeA, RDFS.subClassOf, (RDFNode)JA.Object));
        TestAssemblerGroup.assertTrue((boolean)fullModel[0].contains(typeB, RDFS.subClassOf, (RDFNode)JA.Object));
    }

    protected void assertMemoryModel(Object object) {
        if (object instanceof Model) {
            Graph g = ((Model)object).getGraph();
            TestAssemblerGroup.assertInstanceOf(GraphMemBase.class, g);
        } else {
            TestAssemblerGroup.fail((String)("expected a Model, but got a " + object.getClass()));
        }
    }

    public void testPassesSelfIn() {
        final AssemblerGroup group = AssemblerGroup.create();
        final Object result = new Object();
        AssemblerBase fake = new AssemblerBase(){

            public Object open(Assembler a, Resource root, Mode irrelevant) {
                Assert.assertSame((String)"nested call should pass in assembler group:", (Object)group, (Object)a);
                return result;
            }
        };
        group.implementWith(JA.Object, (Assembler)fake);
        TestAssemblerGroup.assertSame((Object)result, (Object)group.open(this.resourceInModel("x rdf:type ja:Object")));
    }
}

