/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.ElementValidator;
import com.ctc.wstx.dtd.MinimalDTDReader;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.ent.EntityDecl;
import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.io.WstxInputData;
import com.ctc.wstx.sr.AttributeCollector;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.util.TextBuilder;

public final class DTDEntityAttr
extends DTDAttribute {
    public DTDEntityAttr(NameKey name, int defValueType, String defValue, int specIndex) {
        super(name, defValueType, defValue, specIndex);
    }

    public DTDAttribute cloneWith(int specIndex) {
        return new DTDEntityAttr(this.mName, this.mDefValueType, this.mDefValue, specIndex);
    }

    public int getValueType() {
        return 5;
    }

    public void validate(ElementValidator v, boolean normalize, AttributeCollector ac, int index) throws WstxException {
        int start;
        TextBuilder tb = ac.getAttrBuilder();
        char[] ch = tb.getCharBuffer();
        int last = tb.getOffset(index + 1) - 1;
        for (start = tb.getOffset(index); start <= last && WstxInputData.isSpaceChar(ch[start]); ++start) {
        }
        if (start > last) {
            this.reportParseError(v, "Empty ENTITY value");
        }
        while (last > start && WstxInputData.isSpaceChar(ch[last])) {
            --last;
        }
        int c = ch[start];
        if (!WstxInputData.is11NameStartChar((char)c) && c != 58) {
            this.reportInvalidChar(v, (char)c, "not valid as the first ID character");
        }
        int hash = c;
        for (int i = start + 1; i <= last; ++i) {
            c = ch[i];
            if (!WstxInputData.is11NameChar((char)c)) {
                this.reportInvalidChar(v, (char)c, "not valid as an ID character");
            }
            hash = hash * 31 + c;
        }
        EntityDecl ent = this.findEntityDecl(v, ch, start, last - start + 1, hash);
        if (normalize) {
            ac.setNormalizedValue(index, ent.getName());
        }
    }

    public void validateDefault(InputProblemReporter rep, boolean normalize) throws WstxException {
        String normStr = this.validateDefaultName(rep, normalize);
        if (normalize) {
            this.mDefValue = normStr;
        }
        EntityDecl ent = ((MinimalDTDReader)rep).findEntity(normStr);
        this.checkEntity(rep, normStr, ent);
    }
}

