/*
 * Created on 09-Jul-2006
 */
package ix.robot;

import ix.icore.domain.Constraint;
import ix.icore.domain.PatternAssignment;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;

//import java.io.IOException;
//import liburbi.UClient;

import liburbi.call.URBIEvent;
import liburbi.call.UCallbackListener;


/**
 * @author Dane Alexander
 *
 * This class used as a listener to listen for robot obstruction information 
 */
public class RobotObstructionCmd implements UCallbackListener {
	public String RobotName;
	
	public RobotObstructionCmd(String RobotName)
	{
		this.RobotName = RobotName;
	}
	
	public void actionPerformed(URBIEvent event)
	{
		try {
			
			
			String patternString = "Obstructed " + RobotName;
			LList pattern = Lisp.elementsFromString(patternString);
			PatternAssignment pa = new PatternAssignment(pattern, PatternAssignment.S_TRUE);
			
		    
		    Constraint c = new Constraint("world-state","effect",Lisp.list(pa));
		    
		    RoboInfo.getIp2().handleNewConstraint(c);
		} catch(Exception e){
			e.printStackTrace();
		}
	}
	
	
	
}
