/*
 * Created on 08-Jul-2006
 *
 */

/**
 * @author Dane Alexander
 *
 * This class used to help update the IP2 Panel on important background information
 * such as if the robot is obstructed or not and the robot's battery life.
 */
package ix.robot;

//import ix.icore.IXAgent;
//import ix.icore.domain.*;
//import ix.util.lisp.*;
import ix.ip2.*;


import liburbi.UClient;

public class RoboInfo extends Thread {
	
	static public Ip2 ip2;
	
	public int port;
	public UClient URBI = null;
	
	public String RobotName;
	
	//Set up listeners to monitor
	public RobotBatteryCmd batterycmd;
	public RobotObstructionCmd robotobstructioncmd;
	public RobotNoObstructionCmd robotnoobstructioncmd;
	
	public RoboInfo(){}
	
	public void setupRobot(Ip2 ip2, int port,String RobotName)
	{
		RoboInfo.ip2 = ip2;
		this.port = port;
		this.RobotName = RobotName;
	}
	
	public void run(){
	//Currently monitor background information
		
		URBI = new UClient("localhost",this.port, UClient.URBI_BUFLEN);
		
		String batterytag = "battery";
		String obstructiontag = "obstruction";
		String noObstructiontag = "noObstruction";
		
		this.batterycmd = new RobotBatteryCmd(this.RobotName);
		this.robotnoobstructioncmd = new RobotNoObstructionCmd(this.RobotName);
		this.robotobstructioncmd = new RobotObstructionCmd(this.RobotName);
			
		try{
			//Setting to listen for the power tag
			URBI.setCallback(this.batterycmd,batterytag);
			URBI.setCallback(this.robotnoobstructioncmd, noObstructiontag);
			URBI.setCallback(this.robotobstructioncmd,obstructiontag);
			
			
		} catch (Exception e){
			e.printStackTrace();
		}
		
		while(true)
		{
			try{
				Thread.sleep(500);
			}catch(InterruptedException e){
				e.printStackTrace();
			}
		}
	}
	
	static public  Ip2 getIp2()
	{
		return RoboInfo.ip2;
	}
	
	public UClient getURBIController()
	{
		return this.URBI;
	}

}
