  (refinement robot-move (robot-move ?robot ?steps)
   (variables ?robot ?steps ?zone)
   (constraints
	(world-state condition (Posture ?robot) = standing)
	(world-state condition (Obstructed ?robot) = false))
   (annotations
	(comments = "Primitive robot Movement in Steps")))

(refinement robot-move-zone(robot-move ?robot ?steps ?zone)
   (variables ?robot ?steps ?zone)
   (constraints
	(world-state condition (Posture ?robot) = standing)
	(world-state condition (Obstructed ?robot) = false)
	(world-state condition (Distance(?robot ?zone)) = ?steps))
   (annotations
	(comments = "Primitive robot Movement in Steps")))

(refinement robot-turn (robot-turn ?robot ?time)
   (variables ?robot ?time)
   (constraints 
	(world-state condition (Posture ?robot) = standing))
   (annotations
	(comments = "Robot time to turn")))

(refinement robot-standup (robot-standup ?robot)
   (variables ?robot)
   (constraints
	(world-state condition (Posture ?robot) = sitting)
	(world-state effect (Posture ?robot) = standing))
   (annotations
	(comments ="Makes the named Robot Stand UP")))

(refinement robot-sitdown (robot-sitdown ?robot)
   (variables ?robot)
   (constraints
	(world-state condition (Posture ?robot) = standing)
	(world-state effect (Posture ?robot) = sitting))
   (annotations
	(comments = "Makes the robot sitdown")))

(refinement robot-stop (robot-stop ?robot)
   (variables ?robot)
   (annotations
	(comments ="Stops All Robot Action")))

(refinement robot-align(robot-align ?robot)
   (variables ?robot)
   (constraints
	(world-state condition (Posture ?robot) = standing))
   (annotations
	(comments ="Returns to initial joint position")))
   
(refinement robot-searchZone(robot-searchZone ?robot ?zone)
   (variables ?robot ?zone)
   (constraints
	(world-state condition (Posture ?robot) = standing))
   (annotations
	(comments ="Searches for the particular zone.")))

(refinement robot-inzone(robot-inzone ?robot)
   (variables ?robot)
   (annotations
	(comments ="Checks to see which zone the robot is currently in")))

(refinement robot-inzoneOCR(robot-inzoneOCR ?robot)
   (variables ?robot)
   (annotations
	(comments ="Checks to see which zone the robot is currently in")))

(refinement robot-gotozoneB(robot-gotozoneB ?robot)
   (variables ?robot)
   (nodes
     (1 (robot-move ?robot 23))
     (2 (robot-turn ?robot 11s))
     (3 (robot-align ?robot))
     (4 (robot-move ?robot 30))
     (5 (robot-turn ?robot -11s))
     (6 (robot-align ?robot))
     (7 (robot-move ?robot 14))
     (8 (robot-turn ?robot -10s))
     (9 (robot-align ?robot))
     (10(robot-move ?robot 2))
     (11(robot-align ?robot))
     (12(robot-inzoneOCR ?robot)))
   (orderings
     (1 2) (2 3) (3 4) (4 5) (5 6) (6 7) (7 8) (8 9) (9 10) (10 11)(11 12))
   (constraints
      (world-state condition (Inzone ?robot) = "ZoneA"))
   (annotations
       (comments ="Robot goes to zone B from Zone A")))

(refinement robot-exitzoneB(robot-exitzoneB ?robot )
   (variables ?robot ?zone)
   (nodes
     (1 (robot-move ?robot -2))
     (2 (robot-turn ?robot -13s))
     (3 (robot-align ?robot))
     (4 (robot-move ?robot 14))
     (5 (robot-turn ?robot 11s))
     (6 (robot-align ?robot))
     (7 (robot-move ?robot 29))
     (8 (robot-turn ?robot -11s))
     (9 (robot-align ?robot))
     (10(robot-move ?robot 29))
     (11(robot-align ?robot))
     (12(robot-turn ?robot 22.5s))
     (13(robot-align ?robot))
     (14(robot-inzoneOCR ?robot)))
   (orderings
     (1 2) (2 3) (3 4) (4 5) (5 6) (6 7) (7 8) (8 9) (9 10) (10 11)(11 12) (12 13) (13 14))
   (constraints
      (world-state condition (Inzone ?robot) = "ZoneB"))
   (annotations
      (comments = "Robot Exits ZoneB and goes to ZoneA")))


(refinement robot-gotozoneD(robot-gotozoneD ?robot)
   (variables ?robot)
   (nodes
     (1 (robot-turn ?robot -19s))
     (2 (robot-align ?robot))
     (3 (robot-move ?robot 30))
     (4 (robot-turn ?robot 5s))
     (5 (robot-align ?robot))
     (6 (robot-move ?robot 18))
     (7 (robot-turn ?robot 12s))
     (8 (robot-align ?robot))
     (9 (robot-move ?robot 17))
     (10(robot-turn ?robot 15s))
     (11(robot-align ?robot))
     (12(robot-turn ?robot 2s))
     (13(robot-move ?robot 2))
     (14(robot-stand ?robot))
     (15(robot-inzoneOCR ?robot)))
   (orderings
      (1 2) (2 3) (3 4) (4 5) ( 5 6) (6 7) (7 8) (8 9) (9 10) (11 12)
      (12 13) (13 14) (14 15))
   (constraints
      (world-state condition (Inzone ?robot) = "ZoneA"))
   (annotations
       (comments ="Robot goes to zone B from Zone A")))

(refinement searchForZoneA(robot-gotoZone ?robot ?zone)
   (variables ?robot ?steps ?zone)
   (nodes
     (1 (robot-searchZone ?robot ZoneA))
     (2 (robot-turn ?robot 1s))
     (3 (robot-align ?robot))
     (4 (robot-move ?robot ?steps ZoneA))
     (5 (robot-inzone ?robot))
     (6 (robot-searchZone ?robot ?zone))
     (7 (robot-turn ?robot 1s))
     (8 (robot-align ?robot))
     (9 (robot-move ?robot ?steps2 ?zone))
     (10 (robot-turn ?robot 1s))
     (11 (robot-align ?robot))
     (12 (robot-inzone ?robot)))
   (orderings
     (1 2)(2 3) (3 4) (4 5) (5 6) (6 7) (7 8) (8 9) (9 10) (10 11) (11 12))
   (annotations
	(comments ="Robot goes to the only if it is in ZoneA and the Zone in question is in sight")))

(refinement gotozone(robot-gotoZone ?robot ?zone)
   (variables ?robot ?steps ?zone)
   (nodes
     (1 (robot-searchZone ?robot ?zone))
     (2 (robot-turn ?robot 1s))
     (3 (robot-align ?robot))
     (4 (robot-move ?robot ?steps ?zone))
     (5 (robot-inzone ?robot)))
   (orderings
     (1 2)(2 3) (3 4) (4 5))
   (constraints
     (world-state condition (Inzone ?robot) = "ZoneA"))
   (annotations
	(comments ="Robot goes to zone only if the zone is in sight")))
