(refinement move-object (move ?object ?to-long ?to-lat)
  (variables ?from-lat ?from-long ?object ?to-lat ?to-long ?vehicle)
  (nodes
    (1 (select-transport-at ?object ?vehicle ?from-long ?from-lat))
    (2 (load ?vehicle ?object))
    (3 (travel ?vehicle ?to-long ?to-lat))
    (4 (unload ?vehicle ?object)))
  (orderings
    (1 2) (2 3) (3 4))
  (constraints
    (world-state condition (latitude ?object) = ?from-lat)
    (world-state condition (longitude ?object) = ?from-long)
    (world-state condition (test) = false)
    (world-state effect (latitude ?object) = ?to-lat)
    (world-state effect (longitude ?object) = ?to-long))
  (annotations
    (comments = "")))

(refinement load-object-onto-vehicle (load ?vehicle ?object)
  (variables ?object ?vehicle)
  (constraints
    (world-state condition (transport-assignment ?vehicle) = ?object))
  (annotations
    (comments = "")))

(refinement travel (travel ?vehicle ?to-long ?to-lat)
  (variables ?to-lat ?to-long ?vehicle)
  (constraints
    (world-state effect (latitude ?vehicle) = ?to-lat)
    (world-state effect (longitude ?vehicle) = ?to-long))
  (annotations
    (comments = "")))

(refinement consider-thing (consider ?x)
  (variables ?x)
  (nodes
    (1 (do ?x part-1))
    (2 (do ?x part-2))
    (3 (do ?x part-3))
    (4 (do ?x part-4)))
  (orderings
    (1 2) (2 3))
  (annotations
    (comments = "Simple example for expanding consider example in demos")))

(refinement use-truck (select-transport-at ?object ?vehicle ?long ?lat)
  (variables ?lat ?long ?vehicle ?object)
  (constraints
    (world-state condition (latitude ?vehicle) = ?lat)
    (world-state condition (longitude ?vehicle) = ?long)
    (world-state condition (type ?vehicle) = truck)
    (world-state effect (transport-assignment ?vehicle) = ?object))
  (annotations
    (comments = "")))

(refinement use-helicopter (select-transport-at ?object ?vehicle ?long ?lat)
  (variables ?lat ?long ?vehicle ?object)
  (nodes
    (1 (seek-authority supervisor assign-helicopter ?object ?vehicle ?long ?lat)))
  (constraints
    (world-state condition (latitude ?vehicle) = ?lat)
    (world-state condition (longitude ?vehicle) = ?long)
    (world-state condition (type ?vehicle) = helicopter)
    (world-state effect (transport-assignment ?vehicle) = ?object))
  (annotations
    (comments = "")))

(refinement unload-object-from-vehicle (unload ?vehicle ?object)
  (variables ?lat ?long ?object ?vehicle)
  (constraints
    (world-state condition (latitude ?vehicle) = ?lat)
    (world-state condition (longitude ?vehicle) = ?long)
    (world-state effect (latitude ?object) = ?lat)
    (world-state effect (longitude ?object) = ?long)
    (world-state effect (transport-assignment ?vehicle) = false))
  (annotations
    (comments = "")))

(refinement hkjg (fdg gffd)
  (nodes
    (1 (do stuff))
    (2 (do more)))
  (orderings
    (1 2))
  (constraints
    (world-state condition (something) = true))
  (annotations
    (comments = "")
    ; Cannot output annotation with key canvasPositionGraph
))

(refinement uhiliy nil
  (annotations
    (comments = "")))
