/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 *    and: Stephen Potter <stephenp@inf.ed.ac.uk>
 * Updated: Tue Jun 20 15:02:30 2006
 * Copyright: (c) 2001-2006 AIAI, University of Edinburgh
 */

package ix.robot;


//import java.io.IOException;
//import java.io.*;
//import java.net.*;
//
//import javax.swing.JOptionPane;
//
//import ix.icore.*;
//import ix.icore.domain.*;
//import ix.util.lisp.*;
//
//import org.jdom.*;
//import org.jdom.input.*;
//
//import liburbi.UClient;
//import ix.util.*;
import ix.util.lisp.*;

import ix.ip2.*;
import java.util.*;

public class SendToRobotHandler extends ItemHandler{
	
    protected Ip2 ip2;
    
    protected RoboInfo rob;

    
    public SendToRobotHandler(Ip2 ip2) {
		
    	super("Send to URBI");
		
		this.ip2 = ip2;
		load();
	
    }

    //Loads the roboinfo class to monitor background information
    private void load(){
    	rob = new RoboInfo();
    	rob.setupRobot(ip2,54000,"Robot1");
    	rob.start();
    	
    	
    }
    
    public List getSyntaxList(){
	return (LList)Lisp.readFromString("((?Internet-search-term))");
    }

    public boolean appliesTo(AgendaItem item) {
	// We want this handler to apply to all agenda items (issues and
	// activities, so we simply return true here - other handlers may
	// have more specific truth conditions (usually based on the content
	// of the agenda item in question).
	return true; 
    }

    public void addHandlerActions(AgendaItem item) {
	item.addAction
	    (new HandlerAction.AutomaticWhenBound(item, this));
    }

    public void handle(AgendaItem item) {
    	
    	SendCmdToRobot SendRobotCmd = new SendCmdToRobot(54000,"Robot1");
    	SendRobotCmd.setAction(item);
    	SendRobotCmd.start();
    }
}



