/*
 * Created on 09-Jul-2006
 *
 */
package ix.robot;

import ix.ip2.*;
import ix.icore.Status;
import liburbi.UClient;

/**
 * @author Dane Alexander
 * The SendCmdToRobot sets other listeners that are to be monitored and also
 * sets a monitor for the current command to execute by the robot.
 */
public class SendCmdToRobot extends Thread{
	
	//IP2 AgendaItem from IP2 panel
	public AgendaItem itemAction=null;
	
        //Port number for AIBO on Webots
	public int port;
	public UClient URBI = null;
	
	public String RobotName;
	
	public SendCmdToRobot(int port, String RobotName){
		
		
		this.port = port;
		this.RobotName = RobotName;
		
	}
	
	//Main Things to run in thread
	synchronized public void run()
	{
		
		//Set Up Connection
                //NOTE: Will need to change the code to accomodate different IPs for different robots
		try{
			URBI = new UClient("localhost",port,UClient.URBI_BUFLEN);
		
		} catch (Exception e){
			e.printStackTrace();
		}
		//Set the Status of the Action on the IP2 Panel
		itemAction.setStatus(Status.EXECUTING);
		
		//Get the I-X Action Command
		String action = itemAction.getShortDescription();
		//Get the URBI tag for this I-X action for monitoring purposes
		String actiontag = RobotCmdLibrary.getMainAction(action);
                //Get the URBI equivalent to the I-X Acton
		String CmdToUse = RobotCmdLibrary.buildCommand(action);
		
		//Set for identifying Colours
		ColourZone camera = new ColourZone(URBI,InterpretIXZone.identifyColour(RobotCmdLibrary.getParamfromAction(action,2)), RobotCmdLibrary.getParamfromAction(action,1));
                
                //Set for identifying Text
		InOCRZone cam = new InOCRZone(URBI, this.RobotName);
		
		
		//System.out.println("********* " + CmdToUse);
		
		//Set to Monitor this thread
		CmdMonitor cmdToNotify = new CmdMonitor(this);

		//Set for identifying the in zone colour
		InColourZone cmd = new InColourZone(RobotCmdLibrary.getParamfromAction(action,1));
		
		try{

	        	URBI.setCallback(camera,"zone");
			URBI.setCallback(cmd,"inzone");
			
			//Set the camera properties.
			URBI.send("motor on;");
			URBI.send("camera.resolution = 0;");
			URBI.send("camera.format = 1;");
			URBI.send("camera.jpegfactor = 90;");
			
			//Set the Callback for these functions for monitoring purposes
			URBI.setCallback(camera,"searching");
			URBI.setCallback(cam, "OCR");
			
			
			URBI.setCallback(cmdToNotify, actiontag);
                        
			//Set the URBI tag action and send the URBI command to execute
			URBI.effectiveSend(actiontag+"+end:"+CmdToUse+",");
			this.wait();
		} catch(Exception e) {
			e.printStackTrace();
		}
		
		//When this function is notified to complete running then set the status 
                //of the IP2 action
		itemAction.setStatus(Status.COMPLETE);
		this.URBI = null;
		this.port = 0;
		this.RobotName = null;
	}

	public void setAction(AgendaItem item)
	{
		this.itemAction = item;
	}
	
	synchronized public void wakeUp()
	{
		this.notify();
	}
}
