/*
 * Created on 09-Jul-2006
 */
package ix.robot;

import java.lang.Exception;
/**
 * @author Dane Alexander
 *
 * This file contains all the primitive actions that the robot can perform
 * with a couple of special built actions for our support functions 
 */
public final class RobotCmdLibrary {

	
	static public String robotSwalk = "robot.swalk(";
	static public String robotSTurn = "robot.turn(";
	
	static public String robotSitDown = "robot.SitDown()";
	static public String robotStandUp = "robot.StandUp()";
	static public String robotLayDown = "robot.LayDown()";
	static public String robotStop = "stopall";
	static public String robotAlign = "robot.stand()";
		
	static public String buildCommand(String cmd)
	{
		String cmdToUse ="";
		String getAction;
		String[] readString = cmd.split("\\s");
		
	
		getAction = readString[0];
		
		
		if(getAction.equals("robot-move"))
		{
			cmdToUse = robotSwalk + getBoundedParam(readString[2]) + ")";
		}
		
		else if(getAction.equals("robot-turn"))
		{
			cmdToUse = robotSTurn + getBoundedParam(readString[2]) +")";
		}
		
		else if(getAction.equals("robot-standup"))
		{
			cmdToUse = robotStandUp;
		}
		
		else if(getAction.equals("robot-sitdown"))
		{
			cmdToUse = robotSitDown;
		}
		
		else if(getAction.equals("robot-stop"))
		{
			cmdToUse = robotStop;
		}
		else if(getAction.equals("robot-align"))
		{
			cmdToUse = robotAlign;
		}
		
		else if(getAction.equals("robot-searchZone"))
		{
			cmdToUse = "freeze robot_searchZone, turn:robot.turn(60s), searchprocess:{{timeout(60s) every(0.3s)  searching:camera.val} | echo \"Failure to Detect " + getBoundedParam(readString[2]) + " \" | unfreeze robot_searchZone | stop turn}" ;
		}
		else if(getAction.equals("robot-inzone"))
		{
			cmdToUse = "freeze robot_inzone, headTilt=-16; wait(2s); inzone:camera.val; headTilt=10 ; unfreeze robot_inzone";
		}
		else if(getAction.equals("robot-inzoneOCR"))
		{
			cmdToUse = "freeze robot_inzoneOCR, timeout(4s) shite:{every(0.3s) OCR:camera.val}, unfreeze robot_inzoneOCR,";
		}
		
		
		return cmdToUse;
	}
	
	static public String getMainAction(String cmd)
	{
		String foo;
		String bar ="";
		String[] readString = cmd.split("\\s");
		foo = readString[0];
		
		if(foo.equals("robot-move"))
		{
			bar = "robot_move";
		}
		
		else if(foo.equals("robot-turn"))
		{
			bar = "robot_turn";
		}
		
		else if(foo.equals("robot-standup"))
		{
			bar = "robot_standup";
		}
		
		else if(foo.equals("robot-sitdown"))
		{
			bar="robot_sitdown";
		}
		
		else if(foo.equals("robot-stop"))
		{
			bar = "robot_stop";
		}
		
		else if(foo.equals("robot-align"))
		{
			bar = "robot_align";
		}
		
		else if(foo.equals("robot-searchZone"))
		{
			bar = "robot_searchZone";
		}
		
		else if(foo.equals("robot-inzone"))
		{
			bar = "robot_inzone";
		}
		else if(foo.equals("robot-inzoneOCR"))
		{
			bar = "robot_inzoneOCR";
		}
		return bar;
	}
	
	//Function used to get the parameter from the string
	public static String getParamfromAction(String action, int num)
	{
		String[] readString = action.split("\\s");
		String foo = "";
		try {
			foo = readString[num];
		} catch (Exception e){ e.printStackTrace();}
		
		return foo;
	}
	
	//Because some I-X Action variables need to be bounded during
	//Plan execution we use this to get the values from these special 
	//parameters.
	 public static String getBoundedParam(String str){
		
		String send="";
		if(str.charAt(0) == '[')
		{
			String[] foo = str.split("=");
			String x = foo[1];
			send = x.replaceFirst("]","");
		}
		else {
			send = str;
		}
		
		return send;
	}
}
