/*
 * Created on 08-Jul-2006
 */

/**
 * @author Dane Alexander
 * This class used as a listener to listen for battery information 
 * from the URBI server
 */

package ix.robot;

import ix.icore.domain.Constraint;
import ix.icore.domain.PatternAssignment;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;

//import java.io.IOException;
//import liburbi.UClient;

import liburbi.call.URBIEvent;
import liburbi.call.UCallbackListener;



public class RobotBatteryCmd implements UCallbackListener {
	
	public String RobotName;
	
	public RobotBatteryCmd(String RobotName){
		this.RobotName = RobotName;
	}
	
	public void actionPerformed(URBIEvent event){
		
		try {
		
			int level = (int)Float.parseFloat(event.getCmd());
			Object value = new Long(level);
			String patternString = "Battery " + RobotName;
			LList pattern = Lisp.elementsFromString(patternString);
			PatternAssignment pa = new PatternAssignment(pattern, value);
			
		    
		    Constraint c = new Constraint("world-state","effect",Lisp.list(pa));
		    
		    RoboInfo.getIp2().handleNewConstraint(c);
		
		} catch(Exception e){ 
			
			e.printStackTrace();
		}
		
		
	    
	}

}
