/*
 * Created on 15-Jul-2006
 *
 */
package ix.robot;

import ix.icore.domain.Constraint;
import ix.icore.domain.PatternAssignment;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.regex.*;

import liburbi.call.URBIEvent;
import liburbi.call.UCallbackListener;
import liburbi.image.ImageUtilities;
import liburbi.UClient;

import com.asprise.util.ocr.OCR;
/**
 * @author Dane Alexander
 *
 */
public class InOCRZone implements UCallbackListener{

	public static OCR ocr;
	public static int frames = 0;
	public  UClient URBI;
	public String RobotName;
	
	public InOCRZone(UClient URBI, String RobotName)
	{
		OCR.setLibraryPath("/home/s0565480/Desktop/ix-4.3/imports/libAspriseOCR.so");
		ocr = new OCR();
		
		this.RobotName = RobotName;
		this.URBI = URBI;
	}
	
	public void actionPerformed(URBIEvent event)
	{
		String foo = "";
		String result = "noZone";
		
		

		if (event.getBinBuffer() == null)
			return ;
		
		int		width = event.getWidth();
		int		height = event.getHeight();

		ImageUtilities.setWidth(width);
		ImageUtilities.setHeight(height);
		
		
		
		 	Image im = ImageUtilities.blockingLoad(event.getBinBuffer());
			
		 	if (im != null)
			{
		 		
		 		//System.out.println("enter zone");
				BufferedImage buffer = ImageUtilities.makeBufferedImage(im);
				
				String s = ocr.recognizeCharacters(buffer);
						
				//Remove all trailing whitespaces
				CharSequence p = removeDuplicateWhitespace(s);
				String p2 = p.toString();
				
				//Split all sentences by whitespaces		
				String[] p3 = p2.split("\\s");
						
				//The number 26 chosen for the text to focus on after 
				//default text
				if(p3.length > 26){
					//Remove irrelevant characters from  result		
					for(int t = 26; t < p3.length ; t++)
					{
						p3[t]= p3[t].toLowerCase();
						if (p3[t].contentEquals("(pic)"))
							p3[t]= "";
						else if (p3[t].contentEquals("i"))
						{
							p3[t]= "";
						} else if (p3[t].contentEquals("l"))
						{
							p3[t]= "";
						} else if (p3[t].contentEquals("1"))
						{
							p3[t]= "";
						}
						else if (p3[t].contentEquals("f"))
						{
							p3[t]= "";
						}
								
						foo = foo + p3[t];
								
						//foo = removeDuplicateWhitespace(foo).toString();
								
								
					}
							
					System.out.println(foo);
					foo = InterpretIXZone.identifyOCR(foo);
					
					//Update IP2 Panel
					Object value = new String(foo);
					String patternString = "Inzone " + this.RobotName;
					LList pattern = Lisp.elementsFromString(patternString);
					PatternAssignment pa = new PatternAssignment(pattern, value );
					Constraint c = new Constraint("world-state","effect",Lisp.list(pa));
					RoboInfo.getIp2().handleNewConstraint(c);
							
				}
						
				buffer.flush();
				buffer = null;
				im.flush();
				im = null;
			}
		
	}

	//Function to used to remove duplicate whitespaces in the default text.
	public static CharSequence removeDuplicateWhitespace(CharSequence inputStr) {
        String patternStr = "\\s+";
        String replaceStr = " ";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(inputStr);
        return matcher.replaceAll(replaceStr);
    }
	
}
