package ix.robot;

import liburbi.call.*;
/**
 * @author Dane Alexander
 *
 * The CmdMonitor is a Callback listener which monitors the current 
 * by cmd being executed by the robot.
 */
public class CmdMonitor implements UCallbackListener {
	
	//This is a thread to be monitored
	SendCmdToRobot currentCmd;
	
	public CmdMonitor(SendCmdToRobot currentCmd)
	{
		this.currentCmd = currentCmd;
	}
	
	//If the action has finished executing on the URBI server then 
        //it is picked up by this function.
	public void actionPerformed(URBIEvent event)
	{
		try{
                //Wake up the sleeping thread
		currentCmd.wakeUp();
		
		//System.out.println("Command is called");
		} catch (Exception e){
			
			e.printStackTrace();
			
		}
		
	}
	
}
