/* Author: Jeff Dalton <J.Dalton@ed.ac.uk> & S.Potter <S.Potter@ed.ac.uk>
 * Updated: Thu Jul 20 19:21:36 2006
 * Copyright: (c) 2001 - 2006, AIAI, University of Edinburgh
 */

package ix.ip2;

import ix.icore.domain.*;
import ix.robot.SendCmdToRobot;
import ix.util.match.*;
import ix.util.Collect;

/**
 * Adds expansion actions to activities based on refinements in
 * the agent's domain.
 */
public class URBIExpandHandler extends ExpandHandler {

    public URBIExpandHandler(Ip2 ip2) {
	super(ip2);
    }

    protected ExpandAction makeExpandAction(AgendaItem item,
					    Refinement r, 
					    MatchEnv env) {
	return new URBIExpandAction(item, r, env);
    }


    public class URBIExpandAction extends ExpandAction{

	URBIExpandAction(AgendaItem item, Refinement refinement, MatchEnv env){
	    super(item, refinement, env);
    	    this.shortDescription = "URBI-Expand using " + refinement.getName();
	}

    //The handle function is called when  is selecting the type of Handler
    //on the IP2 Panel.
    public void handle(AgendaItem item){
       super.handle(item);

       //Check to see if the refinement is a primitive action, since we only send
       //primitive actions to the Robot Controller
       if (Collect.isEmpty(item.getChildren()))
       {
	   //Setup connection to Robot Controller
	   SendCmdToRobot SendRobotCmd = new SendCmdToRobot(54000,"Robot1");
	   SendRobotCmd.setAction(item);
	   SendRobotCmd.start();
       }

    }


	// The final command in super.handle is a call to the method
	// setSatusAfterExpansion(AgendaItem item), which is defined
	// as below.
	// This sets the status to complete, if there are no child
	// nodes...however, you may wish to override this method so 
	// that the status is not set to complete at this point, and 
	// add some code somewhere else that later sets it to complete
	// following appropriate feedback from the robot.

	//  	protected void setSatusAfterExpansion(AgendaItem item) {
	//  	    // /\/: We know any conds have been satisfied -- otherwise
	//  	    // we wouldn't have let the refinement be used -- and so
	//  	    // the begin end of the activity can be COMPLETE.  And
	//  	    // if there are no children, the whole activity can be
	//  	    // COMPLETE.
	//  	    item.setStatus
	//  		(Collect.isEmpty(item.getChildren())
	//  		 ? Status.COMPLETE 
	//  		 : Status.EXECUTING);
	//  	}


    }

	

}
