/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Mar  1 11:38:35 2007 by Jeff Dalton
 * Copyright: (c) 2006, 2007, AIAI, University of Edinburgh
 */

package ix.iglobe.test.shared;

import iglobe.plan.RescueTask;
import iglobe.plan.RescuePlan;

import ix.iglobe.test.RescuePlanner; // for reference in javadocs

/**
 * The visible functionality of an I-X agent when it is used
 * inside an AGlobe agent in a {@link RescuePlanner}.
 */
public interface IGlobeIXAgent {

    /**
     * Record the callback that allows this I-X agent to
     * call methods provided by its enclosing AGlobe agent.
     * This is called shortly after the I-X agent is created
     * and is not called again.
     */
    public void setIGlobeCallback(IGlobeCallback callback);

    /**
     * Tells the I-X agent that a new task has been received.
     */
    public void newTask(RescueTask task);

    /**
     * Tells the I-X agent that the task could not be scheduled
     * because certain resources were not available.  A list
     * of the names of those resources (as Strings) should be
     * returned by the task's {@link RescueTask#getUnavailableResources()}.
     */
    public void schedulingFailure(RescueTask task);

    /**
     * Asks the I-X agent to display the plan in a suitable way.
     */
    public void viewPlan(RescuePlan plan); // should this exist? /\/

}
