/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Mar  1 02:12:11 2007 by Jeff Dalton
 * Copyright: (c) 2006, 2007, AIAI, University of Edinburgh
 */

package ix.iglobe.test.shared;

import java.util.List;

import iglobe.plan.RescuePlan;
import iglobe.plan.RescueTask;

import ix.iglobe.test.RescuePlanner; // for refs in javadocs

/**
 * The functionality that the enclusing AGlobe agent in a
 * {@link RescuePlanner} makes visible the the I-X agent it contains.
 * This is given to the I-X agent by calling it's
 * {@link IGlobeIXAgent#setIGlobeCallback(IGlobeCallback)} method.
 */
public interface IGlobeCallback {

    /**
     * Called to request a new task. This is used when testing and
     * debugging so that no external source of tasks is required.
     */
    public void generateTask();

    /**
     * Called to request a new task. This is used when testing and
     * debugging so that no external source of tasks is required.
     *
     * @param unavailableResources  the names of resources
     *     that cannot be used.
     */
    public void generateTask(List<String> unavailableResources);

    /**
     * Gives a plan a task to the AGlobe agent.
     */
    public void takePlan(RescuePlan plan, RescueTask task);

    /**
     * Called when no plan can be found for a task.
     */
    public void noPlan(RescueTask task);

    /**
     * Asks the {@link RescuePlanner} to exit.
     */
    public void exit();

}
