/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Mar  1 02:15:16 2007 by Jeff Dalton
 * Copyright: (c) 2007, AIAI, University of Edinburgh
 */

package iglobe.plan;

import java.io.Serializable;

import java.util.List;

/**
 * Represents a simple rescue task.
 */
public class RescueTask implements Serializable {

    protected String id;
    protected String location;
    protected int numberInjured;
    protected List<String> unavailableResources;

    /**
     * Creates an empty task.
     */
    public RescueTask() {
    }

    public RescueTask(String location, int numberInjured) {
	this.location = location;
	this.numberInjured = numberInjured;
    }

    /**
     * Returns this task's id.
     */
    public String getId() {
	return id;
    }

    /**
     * Sets this task's id.
     */
    public void setId(String id) {
	this.id = id;
    }

    /**
     * Gets the location of the injured.
     */
    public String getLocation()  {
	return this.location;
    }

    /**
     * Sets the location of the injured.
     */
    public void setLocation(String argLocation) {
	this.location = argLocation;
    }

    /**
     * Gets the number injured.
     */
    public int getNumberInjured()  {
	return this.numberInjured;
    }

    /**
     * Sets the number injured
     */
    public void setNumberInjured(int argNumberInjured) {
	this.numberInjured = argNumberInjured;
    }

    /**
     * Gets the unavailable resources.
     */
    public List<String> getUnavailableResources() {
	return unavailableResources;
    }

    /**
     * Sets the unavailable resources.
     */
    public void setUnavailableResources(List<String> unavailableResources) {
	this.unavailableResources = unavailableResources;
    }

    public String toString() {
	return "RescueTask[" + location + ", " + numberInjured +
	    (unavailableResources == null ? ""
	       : ", unavailable=" + unavailableResources) +
	    "]";
    }

}
