/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Nov  7 15:51:34 2006 by Jeff Dalton
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package iglobe.plan;

/**
 * An ordering constraint between two activities.  It says
 * that the first ("from") must be complete before the
 * second ("to") can begin.  The {@link RescueActivity activities}
 * are represented by their ids.
 */
public class OrderConstraint extends PlanConstraint {

    String fromId;
    String toId;

    /**
     * Creates an empty constraint.
     */
    public OrderConstraint() {
    }

    public String getFromId()  {
	return this.fromId;
    }

    public void setFromId(String newFromId) {
	this.fromId = newFromId;
    }

    public String getToId()  {
	return this.toId;
    }

    public void setToId(String newToId) {
	this.toId = newToId;
    }


}
