/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.visual;

/**
 * <code>VisString</code> is used by other VisXXX classes to diplay strings in
 * the structure trees with vatious icons (like Agent Name, City, Location, ...).
 */


public class VisString implements TreeMember
{
  String _value;
  int    _type;

  public VisString(String value, int type)
  {
    _value= value;
    _type= type;
  }

  public String toString()
  {
    return _value;
  }

  /**
   * TreeMember methods
   */
  public Object getChild(int index)
  {
    throw new java.lang.UnsupportedOperationException("String doesnt have any children.");
  }

  public int getChildCount()
  {
    return 0;
  }

  public boolean isLeaf()
  {
    return true;
  }

  public int getIndexOfChild(Object child)
  {
    return -1;
  }

  public int getNodeType()
  {
    return _type;
  }
}