/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.visual;

/**
 * The only purpose of <code>VisCoalitionLeader</code> is to provide a different
 * icon to an agent when it acts as coalition leader. It redirects most of the
 * method calls to its parent agent.
 *
 * @see VisAgent
 */

public class VisCoalitionLeader implements TreeMember
{
  VisAgent _self;

  public VisCoalitionLeader(VisAgent self)
  {
    _self= self;
  }

  public VisAgent getSelf()
  {
    return _self;
  }

  public String toString()
  {
    return _self.toString();
  }

  public Object getChild(int index)
  {
    return _self.getChild(index);
  }

  public int getChildCount()
  {
    return _self.getChildCount();
  }

  public boolean isLeaf()
  {
    return _self.isLeaf();
  }

  public int getIndexOfChild(Object child)
  {
    return _self.getIndexOfChild(child);
  }

  public int getNodeType()
  {
    return ntCOALITIONLEADER;
  }
}