/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.visual;

// JAVA imports
import java.awt.Point;
import java.util.List;

import aglobe.ontology.AgentInfo;

// MY imports

/**
 * <code>VisAgentInterface</code> encapsulates functionality provided by
 * <code>VisAgent</code> and <code>PhantomAgent</code> classes used by
 * <code>AgentInfo</code> and <code>VisAlliance</code>.
 *
 * @see VisAgent
 * @see PhantomAgent
 * @see AgentInfo
 * @see VisAlliance
 */


public interface VisAgentInterface
{

  public String getType();

//  public String getName()

  public String getCountry();

  public String getCity();

  public Object getRole();

  public void setRole(Object role);

  public List getCoalitions();

  public Point getLocation();

  public void setLocation(int x, int y);
  public void setLocation(Point p);

  public void refreshColor();

  public boolean getVisibility();
}