/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.visual;


// JAVA imports
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;


// MY imports

/**
 * <p><code>TaskTreeModel</code> is data model for task structure tree. It generates
 * the root node and resolves the link between the root and the other elements.
 * All other elements in the tree implement <code>TreeMember</code> interface,
 * so most of the call can be redirected to the element itself.</p>
 * <p><code>TaskTreeModel</code> is similar to the <code>AllianceTreeModel</code>,
 * they differ mostly in the root structure.</p>
 *
 * @see TaskTreeModel
 * @see TreeMember
 * @see VisAgent
 * @see VisAlliance
 * @see VisTask
 * @see VisString
 * @see VisCoalition
 * @see VisCoalitionLeader
 *
 */


public class TaskTreeModel implements TreeModel
{
  private final VisString ROOT = new VisString("Tasks", TreeMember.ntTASKROOT);

  private List _tasks;

  private List _listeners;

  public TaskTreeModel(List tasks)
  {
    _tasks= tasks;
    _listeners= new LinkedList();
  }

  public Object getRoot()
  {
    return ROOT;
  }

  public Object getChild(Object parent, int index)
  {
    if(parent==ROOT)
      return _tasks.get(index);
    else if(parent instanceof TreeMember)
      return ((TreeMember)parent).getChild(index);
    else
      return null;
  }

  public int getChildCount(Object parent)
  {
    if(parent==ROOT)
      return _tasks.size();
    else if(parent instanceof TreeMember)
      return ((TreeMember)parent).getChildCount();
    else
      return 0;
  }

  public boolean isLeaf(Object node)
  {
    if(node==ROOT)
    {
      return false;
    }
    else if(node instanceof TreeMember)
      return ((TreeMember)node).isLeaf();
    else
      return false;
  }

  public void valueForPathChanged(TreePath path, Object newValue)
  {
    /**@todo: Implement this javax.swing.tree.TreeModel method*/
    throw new java.lang.UnsupportedOperationException("Method valueForPathChanged() not yet implemented.");
  }

  public int getIndexOfChild(Object parent, Object child)
  {
    if(parent==ROOT)
      return _tasks.indexOf(child);
    else if(parent instanceof TreeMember)
      return ((TreeMember)parent).getIndexOfChild(child);
    else
      return -1;
  }

  public synchronized void addTreeModelListener(TreeModelListener l)
  {
    _listeners.add(l);
  }

  public synchronized void removeTreeModelListener(TreeModelListener l)
  {
    if(_listeners.contains(l))
      _listeners.remove(l);
  }


  protected void fireTreeChange()
  {
    TreeModelEvent e= new TreeModelEvent(this, new Object [] {ROOT});

    Iterator i= _listeners.iterator();
    while(i.hasNext())
      ((TreeModelListener)i.next()).treeStructureChanged(e);

  }


  protected synchronized void fireNodeChanged(Object[] path, Object node){
    int len = 0;
    if (path != null) {
      len = path.length;
    }

    Object[] p = new Object[len+1];
    p[0] = ROOT;
    for (int j=1;j<p.length;j++) {
      p[j]=path[j-1];
     }

    TreeModelEvent e = new TreeModelEvent(this, p, null, new Object[] {node});

    Iterator i= _listeners.iterator();
    while(i.hasNext())
      ((TreeModelListener)i.next()).treeNodesInserted(e);

  }

  protected synchronized void fireNodeInserted(Object[] path, final int[] nodes) {
    int len = 0;
    if (path != null) {
      len = path.length;
    }

    Object[] p = new Object[len+1];
    p[0] = ROOT;
    for (int j=1;j<p.length;j++) {
      p[j]=path[j-1];
     }

    TreeModelEvent e = new TreeModelEvent(this, p) {
      public int[] getChildIndices() {
         return nodes;
      }
  };


    Iterator i= _listeners.iterator();
    while(i.hasNext())
      ((TreeModelListener)i.next()).treeNodesInserted(e);

  }

}
