/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.visual;

// JAVA imports
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;

import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

// MY imports

public class ShadowBorder extends AbstractBorder implements DISPLAYCONST
{
  private static Border _standardshadow;

  protected int   _thickness;
  protected Color _shadowcolor;
  protected Color _backcolor;


  public ShadowBorder(int thickness, Color shadowcolor, Color backcolor)
  {
    _thickness= thickness;
    _shadowcolor= shadowcolor;
    _backcolor= backcolor;
  }

  public ShadowBorder()
  {
    this(SHADOWTHICK, SHADOWCOLOR, SHADOWBCOLOR);
  }

  public static Border createStandardShadow()
  {
    if(_standardshadow==null)
      _standardshadow= new ShadowBorder();

    return _standardshadow;
  }

  public void paintBorder(Component c, Graphics g, int x, int y, int width, int height)
  {
    Color oldColor = g.getColor();
    int i;

    g.setColor(_shadowcolor);
    for(i = 0; i < _thickness; i++)
    {
      g.drawLine( x+_thickness, y+height-i-1, x+width, y+height-i-1);
      g.drawLine( x+width-i-1, y+_thickness, x+width-i-1, y+width);
    }
    g.setColor(_backcolor);
    for(i = 0; i < _thickness; i++)
    {
      g.drawLine( x, y+height-i-1, x+_thickness-1, y+height-i-1);
      g.drawLine( x+width-i-1, y, x+width-i-1, y+_thickness-1);
    }
    g.setColor(oldColor);
  }

  /**
   * Returns the insets of the border.
   * @param c the component for which this border insets value applies
   */
  public Insets getBorderInsets(Component c)
  {
    return new Insets(0, 0, _thickness, _thickness);
  }

  /**
   * Returns whether or not the border is opaque.
   */
  public boolean isBorderOpaque()
  {
    return false;
  }

}