/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.visual;

// JAVA imports
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.Iterator;

import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

import across.visio.VisualAgent;
import aglobe.container.Store;

/**
 * <code>Screen</code> is the <i>Visualiser's</i> main window.
 */


public class Screen extends JFrame
{
  // indicates whether Alliances are autoarranged into Tiles or Cascade
  public boolean _tiling= VisualAgent.getConfig().getTileArrange();

  private Visualizer _owner;
  private TreeModel _alliancemodel;
  private final Store store;
  private static final String GUI_X= "gui/x";
  private static final String GUI_Y= "gui/y";
  private static final String GUI_W= "gui/w";
  private static final String GUI_H= "gui/h";


  //private TreeModel _alliancemodel;
  private TreeModel _tasktreemodel;
  private TreeModel _coalitionstreemodel;
  private boolean showfull = true; //false;

  private LegendWindow _legend= new LegendWindow();
  private ToolWindow   _icons= new IconWindow();
  private AgentInfoPanel    _agentinfo= AgentInfoPanel.DefaultAgentInfo;

  private AbstractAction KeyAction;
  private AbstractAction IconAction;

  private MyDesktopManager _desktopmanager= new MyDesktopManager();

  private JPanel contentPane;
  private JSplitPane jSplitPane1 = new JSplitPane();
  private JSplitPane jSplitPane2 = new JSplitPane();
  private JScrollPane jScrollPane1 = new JScrollPane();
  private JScrollPane jScrollPane2 = new JScrollPane();
  private JDesktopPane _desktop = new JDesktopPane();
  private JTree _tasktree;
  private JTree _alliancetree;
  private BorderLayout borderLayout1 = new BorderLayout();
  private JToolBar jToolBar1 = new JToolBar();
  private JLabel jLabel1 = new JLabel();
  private JComboBox ColorCombo = new JComboBox();
  private JMenuBar jMenuBar1 = new JMenuBar();
  private JMenu FileMenu = new JMenu();
  private JMenuItem MenuQuit = new JMenuItem();
  private ButtonGroup LFgroup = new ButtonGroup();
  private JMenu ViewMenu = new JMenu();
  private JMenu MenuLF = new JMenu();
  private JRadioButtonMenuItem MetalLF = new JRadioButtonMenuItem();
  private JRadioButtonMenuItem MotifLF = new JRadioButtonMenuItem();
  private JRadioButtonMenuItem WindowsLF = new JRadioButtonMenuItem();
  private JCheckBoxMenuItem KeyCheckbox;
  private JToggleButton ColorKeyButton;
  private JCheckBoxMenuItem IconCheckbox;
  private JToggleButton IconButton;
  private JButton TileButton = new JButton();
  private JButton CascadeButton = new JButton();
  private Component component1;
  private JMenuItem TileMenuItem = new JMenuItem();
  private JMenuItem CascadeMenuItem = new JMenuItem();
  JButton CoalitionsButton = new JButton();


  public Screen(Visualizer owner, AllianceTreeModel alliancemodel, TreeModel tasktreemodel, TreeModel coalitionstreemodel)
  {
    store = owner._owner.getContainer().getAgentStore(owner._owner.getName());
    try
    {
      _owner= owner;

      _alliancemodel= alliancemodel;
      _alliancetree= new JTree(_alliancemodel);
      _alliancetree.setRootVisible(false);
      _alliancetree.setCellRenderer(new MyTreeCellRenderer());
      _alliancetree.putClientProperty("JTree.lineStyle", "Angled");
      _alliancetree.expandPath(new TreePath(new Object[] {alliancemodel.ROOT, alliancemodel.AGENTROOT} ));
      _alliancetree.expandPath(new TreePath(new Object[] {alliancemodel.ROOT, alliancemodel.ALLIANCEROOT} ));

      _tasktreemodel= tasktreemodel;
      _tasktree = new JTree(_tasktreemodel);
      _tasktree.setCellRenderer(new MyTreeCellRenderer());
      _tasktree.putClientProperty("JTree.lineStyle", "Angled");

      _coalitionstreemodel = coalitionstreemodel;

      ColorCombo.addItem(ColorFactory.countryGetter);
      ColorCombo.addItem(ColorFactory.roleGetter);
      ColorCombo.addItem(ColorFactory.typeGetter);
      ColorCombo.addItem(ColorFactory.cityGetter);

/*     ColorCombo.addItem(ColorFactory.roleGetter);
     ColorCombo.addItem(ColorFactory.typeGetter);
     ColorCombo.addItem(ColorFactory.countryGetter);
     ColorCombo.addItem(ColorFactory.cityGetter); */


      _desktop.setDesktopManager(_desktopmanager);

      jbInit();

      pack();

      _legend.setShowAction(KeyAction);
      JLayeredPane layeredPane = getLayeredPane();
      _legend.setVisible(false);
      _legend.setSnapTo(_desktop, ToolWindow.snapIN);
      layeredPane.add(_legend, JLayeredPane.PALETTE_LAYER);

      _icons.setShowAction(IconAction);
      _icons.setVisible(false);
      _icons.setSnapTo(jSplitPane2, ToolWindow.snapOUT);
      layeredPane.add(_icons, JLayeredPane.PALETTE_LAYER);

      _agentinfo.setVisible(false);
      layeredPane.add(_agentinfo, new Integer(JLayeredPane.PALETTE_LAYER.hashCode()+1));

      // JBuilder doesn't like float as parameter here
      jSplitPane2.setDividerLocation(0.5);
      jSplitPane2.setDividerSize(3);

      setIconImage((new ImageIcon(Screen.class.getResource("images/agent.gif"))).getImage());
//      Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
//      setLocation(0, 0);
//      setSize(screenSize.width, 600);
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
    setVisible(true);
  }

  private void jbInit() throws Exception
  {
    KeyAction = new AbstractAction("Color Key", new ImageIcon(Screen.class.getResource("images/colorkey.gif")))
                  {
                    public void actionPerformed(ActionEvent e)
                    {
                      boolean newstate= !_legend.isVisible();
                      ColorKeyButton.setSelected(newstate);
                      KeyCheckbox.setSelected(newstate);
                      _legend.setVisible(newstate);
                    }
                  };

    IconAction = new AbstractAction("Icon Key", new ImageIcon(Screen.class.getResource("images/agent.gif")))
                  {
                    public void actionPerformed(ActionEvent e)
                    {
                      boolean newstate= !_icons.isVisible();
                      IconButton.setSelected(newstate);
                      IconCheckbox.setSelected(newstate);
                      _icons.setVisible(newstate);
                    }
                  };

    KeyCheckbox= new JCheckBoxMenuItem(KeyAction);
    ColorKeyButton= new JToggleButton(KeyAction);

    IconCheckbox= new JCheckBoxMenuItem(IconAction);
    IconButton= new JToggleButton(IconAction);

    contentPane = (JPanel)this.getContentPane();
    component1 = Box.createVerticalStrut(8);
    jSplitPane2.setOrientation(JSplitPane.VERTICAL_SPLIT);
    contentPane.setLayout(borderLayout1);
    this.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
    this.setTitle("Inacc Visualizer");
    this.addWindowListener(new java.awt.event.WindowAdapter()
    {
      public void windowClosing(WindowEvent e)
      {
        this_windowClosing(e);
      }
    });
    jLabel1.setLabelFor(ColorCombo);
    jLabel1.setText("Color by ");
    ColorCombo.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        ColorCombo_actionPerformed(e);
      }
    });
    ColorCombo.setMaximumSize(new Dimension(200, 21));
    ColorCombo.setToolTipText("Property to Color Agents by");

    _tasktree.addMouseListener(new java.awt.event.MouseAdapter()
    {
      public void mousePressed(MouseEvent e)
      {
        TreeMaybePopUp(e);
      }
      public void mouseReleased(MouseEvent e)
      {
        TreeMaybePopUp(e);
      }
    });
    _alliancetree.addMouseListener(new java.awt.event.MouseAdapter()
    {
      public void mousePressed(MouseEvent e)
      {
        TreeMaybePopUp(e);
      }
      public void mouseReleased(MouseEvent e)
      {
        TreeMaybePopUp(e);
      }
    });

    FileMenu.setText("File");
    FileMenu.setMnemonic(KeyEvent.VK_F);
    MenuQuit.setText("Quit");
    MenuQuit.setAccelerator(javax.swing.KeyStroke.getKeyStroke(88, java.awt.event.KeyEvent.ALT_MASK, false));
    MenuQuit.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        MenuQuit_actionPerformed(e);
      }
    });
    ViewMenu.setText("View");
    ViewMenu.setMnemonic(KeyEvent.VK_V);
    MenuLF.setText("L&F");
    MetalLF.setText("Metal");
    MetalLF.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        MetalLF_actionPerformed(e);
      }
    });
    MotifLF.setText("Motif");
    MotifLF.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        MotifLF_actionPerformed(e);
      }
    });
    WindowsLF.setText("Windows");
    WindowsLF.setSelected(true);
    WindowsLF.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        WindowsLF_actionPerformed(e);
      }
    });

    ColorKeyButton.setText("");
    ColorKeyButton.setToolTipText("Show/Hide the Color Key");
    ColorKeyButton.setMargin(new Insets(0,0,0,0));
    KeyCheckbox.setAccelerator(javax.swing.KeyStroke.getKeyStroke(75, 0, false));
    IconButton.setText("");
    IconButton.setToolTipText("Show/Hide the Icon Key");
    IconButton.setMargin(new Insets(0,0,0,0));
    IconCheckbox.setAccelerator(javax.swing.KeyStroke.getKeyStroke(73, 0, false));
    TileButton.setMargin(new Insets(0,0,0,0));
    TileButton.setIcon(new ImageIcon(Screen.class.getResource("images/tiles.gif")));
    TileButton.setToolTipText("Tile Alliances");
    TileButton.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        TileButton_actionPerformed(e);
      }
    });
    CascadeButton.setMargin(new Insets(0,0,0,0));
    CascadeButton.setIcon(new ImageIcon(Screen.class.getResource("images/cascade.gif")));
    CascadeButton.setToolTipText("Cascade Alliances");
    CascadeButton.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        CascadeButton_actionPerformed(e);
      }
    });
    TileMenuItem.setText("Tile");
    TileMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(84, 0, false));
    TileMenuItem.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        TileButton_actionPerformed(e);
      }
    });
    CascadeMenuItem.setText("Cascade");
    CascadeMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(67, 0, false));
    CascadeMenuItem.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        CascadeButton_actionPerformed(e);
      }
    });
 /*   CascadeButton1.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        CascadeButton1_actionPerformed(e);
      }
    }); */
  //  CoalitionButton.setToolTipText("Cascade Alliances");
  //  CoalitionButton.setIcon(new ImageIcon(Screen.class.getResource("images/cascade.gif")));
 //   CoalitionButton.setMargin(new Insets(0,0,0,0));
   // CoalitionButton.addActionListener(new java.awt.event.ActionListener() {
   //   public void actionPerformed(ActionEvent e) {
    //    CoalitionsButton_actionPerformed(e);
    //  }
    //});

    CoalitionsButton.setToolTipText("Show/Hide coalition tree");
    CoalitionsButton.setIcon(new ImageIcon(Screen.class.getResource("images/coalition.gif")));
    CoalitionsButton.setMargin(new Insets(0,0,0,0));
    CoalitionsButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        CoalitionsButton_actionPerformed(e);
      }
    });
    jSplitPane2.add(jScrollPane1, JSplitPane.TOP);
    jSplitPane2.add(jScrollPane2, JSplitPane.BOTTOM);
    jScrollPane1.getViewport().add(_tasktree, null);
    jScrollPane2.getViewport().add(_alliancetree, null);

    jSplitPane1.add(jSplitPane2, JSplitPane.LEFT);
    jSplitPane1.add(_desktop, JSplitPane.RIGHT);
    contentPane.add(jToolBar1,  BorderLayout.NORTH);
    jToolBar1.addSeparator();
    jToolBar1.add(jLabel1, null);
    jToolBar1.add(ColorCombo, null);
    jToolBar1.addSeparator();
    jToolBar1.add(IconButton);
    jToolBar1.add(ColorKeyButton);
    jToolBar1.addSeparator();
    jToolBar1.add(TileButton);
    jToolBar1.add(CascadeButton, null);
    jToolBar1.add(CoalitionsButton, null);
    jToolBar1.add(component1, null);
    jSplitPane1.setDividerLocation(200);
    contentPane.add(jSplitPane1,  BorderLayout.CENTER);
    jMenuBar1.add(FileMenu);
    jMenuBar1.add(ViewMenu);
    FileMenu.add(MenuQuit);
    this.setJMenuBar(jMenuBar1);
    MenuLF.add(MetalLF);
    MenuLF.add(WindowsLF);
    MenuLF.add(MotifLF);
    LFgroup.add(MetalLF);
    LFgroup.add(WindowsLF);
    LFgroup.add(MotifLF);
    ViewMenu.add(MenuLF);
    ViewMenu.addSeparator();
    ViewMenu.add(IconCheckbox);
    ViewMenu.add(KeyCheckbox);
    ViewMenu.addSeparator();
    ViewMenu.add(TileMenuItem);
    ViewMenu.add(CascadeMenuItem);
  }

  public void setVisible(boolean parm1) {
    if (!parm1) {
      java.awt.Point p= getLocation();
      store.putInt(GUI_X, p.x);
      store.putInt(GUI_Y, p.y);

      Dimension d= getSize();
      store.putInt(GUI_W, d.width);
      store.putInt(GUI_H, d.height);
    } else {
      if (store.exist(GUI_X)) {
        java.awt.Point loc = getLocation();
        int x = store.getInt(GUI_X, loc.x);
        int y = store.getInt(GUI_Y, loc.y);
        setLocation(x, y);

        Dimension d = getPreferredSize();
        int w = store.getInt(GUI_W, d.width);
        int h = store.getInt(GUI_H, d.height);
        setSize(w, h);
      }
    }
    super.setVisible(parm1);
  }

  public JTree getAllianceTree()
  {
    return _alliancetree;
  }

  public JDesktopPane getDesktop()
  {
    return _desktop;
  }

  public JTree getTaskTree()
  {
    return _tasktree;
  }

  /**
   * Just for testing.
   *
   * @param args String[]
   */
  public static void main(String[] args)
  {
//    Screen screen = new Screen(null, new DefaultTreeModel(null), new DefaultTreeModel(null));
//    screen.show();
  }

  void ColorCombo_actionPerformed(ActionEvent e)
  {
    JComboBox cb= (JComboBox)e.getSource();
    _owner.setColorSchema((ColorFactory.PropertyGetter)cb.getSelectedItem());
  }

  void TreeMaybePopUp(MouseEvent e)
  {
    Object src= e.getSource();
    if(e.isPopupTrigger() && (src instanceof JTree))
    {
      TreePath p = ((JTree)src).getPathForLocation(e.getX(), e.getY());

      if(p!=null)
      {
        final Object o= p.getLastPathComponent();

        JPopupMenu TaskTreePopUp = new JPopupMenu();
        JMenuItem PopUpDisplay = new JMenuItem();

        if(o instanceof VisTask)
        {
          PopUpDisplay.setText("Display");
          PopUpDisplay.addActionListener(new java.awt.event.ActionListener()
          {
            public void actionPerformed(ActionEvent e)
            {
              _owner.setDisplayTask((VisTask)o);
            }
          });
        }
        else if(o instanceof VisAlliance)
        {
          PopUpDisplay.setText("Move to Top");
          PopUpDisplay.addActionListener(new java.awt.event.ActionListener()
          {
            public void actionPerformed(ActionEvent e)
            {
              _desktop.getDesktopManager().activateFrame((VisAlliance)o);
            }
          });
        }

        TaskTreePopUp.add(PopUpDisplay);
        TaskTreePopUp.show(e.getComponent(), e.getX(), e.getY());
      }
    }
  }

  public void autoArrangeAlliances()
  {
    if(!_desktopmanager.wasUserResized() && VisualAgent.getConfig().getAutoArrange())
    {
      if(_tiling)
        tileAlliances();
      else
        cascadeAlliances();
    }
  }

  public void tileAlliances()
  {
    _tiling= true;
    DesktopManager dm= _desktop.getDesktopManager();
    java.util.List alliances= _owner.getAlliances();

    int remainder= alliances.size();
    if(remainder>0)
    {
      Iterator i= alliances.iterator();

      int rows= (int)Math.round(Math.ceil(Math.sqrt(alliances.size())));
      int height= _desktop.getHeight()/rows;
      for(int row= 0; row<rows; row++)
      {
        int colls= (int)Math.round(Math.floor(remainder/(rows-row)));
        remainder-= colls;
        int width= _desktop.getWidth()/colls;
        for(int coll= 0; coll<colls; coll++)
        {
          VisAlliance a= (VisAlliance)i.next();
          dm.setBoundsForFrame(a, coll*width, row*height, width, height);
          a.arrange();
        }
      }
    }
  }

  public void cascadeAlliances()
  {
    _tiling= false;

    DesktopManager dm= _desktop.getDesktopManager();
    java.util.List alliances= _owner.getAlliances();

    int width= _desktop.getWidth()/2;
    int height= _desktop.getHeight()/2;

    Iterator i= alliances.iterator();
    int pos= 0;
    while(i.hasNext())
    {
        VisAlliance a= (VisAlliance)i.next();
        Dimension d= a.getPreferredSize();
        int w= width>d.width ? width : d.width;
        int h= height>d.height ? height : d.height;
        dm.setBoundsForFrame(a, pos*23, pos*23, w, h);
        pos++;
        a.arrange();
        a.moveToFront();
    }
  }

  void MetalLF_actionPerformed(ActionEvent e)
  {
    try
    {
      UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
      SwingUtilities.updateComponentTreeUI(this);
      _alliancetree.setCellRenderer(new MyTreeCellRenderer());
      _tasktree.setCellRenderer(new MyTreeCellRenderer());
      _icons.setSize(_icons.getPreferredSize());
    }
    catch (Exception ex) { }
  }

  void WindowsLF_actionPerformed(ActionEvent e)
  {
    try
    {
      UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
      SwingUtilities.updateComponentTreeUI(this);
      _alliancetree.setCellRenderer(new MyTreeCellRenderer());
      _tasktree.setCellRenderer(new MyTreeCellRenderer());
      _icons.setSize(_icons.getPreferredSize());
    }
    catch (Exception ex) { }
  }

  void MotifLF_actionPerformed(ActionEvent e)
  {
    try
    {
      UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
      SwingUtilities.updateComponentTreeUI(this);
      _alliancetree.setCellRenderer(new MyTreeCellRenderer());
      _tasktree.setCellRenderer(new MyTreeCellRenderer());
      _icons.setSize(_icons.getPreferredSize());
    }
    catch (Exception ex) { }
  }

  void Borland_actionPerformed(ActionEvent e) {
  }


  void MenuQuit_actionPerformed(ActionEvent e)
  {
    _owner.quit();
  }

  void this_windowClosing(WindowEvent e)
  {
    _owner.quit();
  }

  void KeyCheckbox_actionPerformed(ActionEvent e)
  {
    _legend.setVisible(!_legend.isVisible());
  }

  void TileButton_actionPerformed(ActionEvent e)
  {
    tileAlliances();
    _tiling = true; // petr
  }

  void CascadeButton_actionPerformed(ActionEvent e)
  {
    cascadeAlliances();
    _tiling = false; //petr
  }

  void CoalitionsButton_actionPerformed(ActionEvent e) {
    if (showfull) {
      _tasktree.setModel(_coalitionstreemodel);
    } else {
      _tasktree.setModel(_tasktreemodel);
    }
    showfull = !showfull;
  }

  private static class MyDesktopManager extends DefaultDesktopManager
  {
    private boolean _wasresize= false;

    public MyDesktopManager() {}
    public boolean wasUserResized() { return _wasresize; }
    public void endResizingFrame(JComponent f)
    {
      _wasresize= true;
      super.endResizingFrame(f);
    }
  }

}
