/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.visual;

// JAVA imports
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.List;

import javax.swing.JLabel;
import javax.swing.SwingConstants;

// MY imports

/**
 * <p><code>PhantomAgent</code> is an auxiliary class which serves to display multiple
 * copies of agent when it participates in more coalitions for one task. Most of
 * this class code was pasted from <code>VisAgent</code>. The common interface
 * of both classes is defined in <code>VisAgentInterface</code>. It would be clearer
 * to use common superclass instead of interface, but this feature had to be added
 * quite quicky and I choose the fastest method.</p>
 *
 * @see VisAgent
 * @see VisAgentInterface
 */

public class PhantomAgent extends JLabel implements VisAgentInterface, DISPLAYCONST
{
  private VisAgent _owner;
  private Object   _role;

  private boolean _infoon= false;

  public PhantomAgent(VisAgent owner)
  {
    _owner= owner;

    _role= ColorFactory.OTHER;
    refreshColor();

    setSize(AGENTWIDTH, AGENTHEIGHT);
    setPreferredSize(new Dimension(AGENTWIDTH, AGENTHEIGHT));
    setBorder(PhantomBorder.createStandardShadow());
    setForeground(AGENTTXTCOLOR);
    setOpaque(true);
    setHorizontalAlignment(SwingConstants.CENTER);

    setText(NAMEPREFIX+"Phantom"+NAMESUFFIX);

    this.addMouseListener(new java.awt.event.MouseAdapter()
    {
      public void mousePressed(MouseEvent e)
      {
        this_mousePressed(e);
      }
      public void mouseReleased(MouseEvent e)
      {
        this_mouseReleased(e);
      }
      public void mouseExited(MouseEvent e)
      {
        this_mouseExited(e);
      }
    });
  }

  public void setOwner(VisAgent owner)
  {
    _owner= owner;
    setText(_owner.getText());
    _owner.addPhantom(this);
  }

  public void clearOwner()
  {
    _owner.removePhantom(this);
  }

  public String getType()
  {
    return _owner.getType();
  }

  public String getCountry()
  {
    return _owner.getCountry();
  }
  public String getCity()
  {
    return _owner.getCity();
  }

  public boolean getVisibility()
  {
    return _owner.getVisibility();
  }

  public void setRole(Object role)
  {
    _role = role;
    refreshColor();
  }
  public Object getRole()
  {
    return _role;
  }
  public List getCoalitions()
  {
    return _owner.getCoalitions();
  }
  public void refreshColor()
  {
    Color backGC = ColorFactory.getDefaultFactory().getColor(this);
    if (!getVisibility()) {
      backGC = backGC.darker();
    }
    setBackground(backGC);
  }

  void this_mousePressed(MouseEvent e)
  {
    _infoon= true;
    AgentInfoPanel.DefaultAgentInfo.activate(e);
  }

  void this_mouseReleased(MouseEvent e)
  {
    if(_infoon)
    {
      _infoon= false;
      AgentInfoPanel.DefaultAgentInfo.deactivate(e);
    }
  }

  void this_mouseExited(MouseEvent e)
  {
    if(_infoon)
    {
      _infoon= false;
      AgentInfoPanel.DefaultAgentInfo.deactivate(e);
    }
  }
}
