/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.visual;

// JAVA imports
import java.awt.Component;
import java.util.Map;
import java.util.TreeMap;

import javax.swing.ImageIcon;
import javax.swing.JProgressBar;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

/**
 * <p><code>MyTreeCellRenderer</code> is used by structure trees to draw various
 * icons to different node types. All nodes implement the <code>TreeMember</code>
 * interface that provides <code>getNodeType</code> method. The icons are stored
 * in <code>images</code> subdirectory of <code>aglobe.agent.visio.visual</code> package.
 * <code>MyTreeCellRenderer</code> uses this method to select the appropriate
 * icon.</p>
 *
 * @see TreeMember
 */

public class MyTreeCellRenderer extends DefaultTreeCellRenderer
{
  public static Map       Icons;

  static
  {
    Icons= new TreeMap();
    Icons.put(new Integer(TreeMember.ntAGENT), new ImageIcon(MyTreeCellRenderer.class.getResource("images/agent.gif")));
    Icons.put(new Integer(TreeMember.ntAGENTCITY), new ImageIcon(MyTreeCellRenderer.class.getResource("images/city.gif")));
    Icons.put(new Integer(TreeMember.ntAGENTCOUNTRY), new ImageIcon(MyTreeCellRenderer.class.getResource("images/country.gif")));
    Icons.put(new Integer(TreeMember.ntAGENTTYPE), new ImageIcon(MyTreeCellRenderer.class.getResource("images/type.gif")));
    Icons.put(new Integer(TreeMember.ntALLIANCE), new ImageIcon(MyTreeCellRenderer.class.getResource("images/alliance.gif")));
    Icons.put(new Integer(TreeMember.ntCOALITION), new ImageIcon(MyTreeCellRenderer.class.getResource("images/coalition.gif")));
    Icons.put(new Integer(TreeMember.ntCOALITIONLEADER), new ImageIcon(MyTreeCellRenderer.class.getResource("images/coalitionleader.gif")));
    Icons.put(new Integer(TreeMember.ntTASK), new ImageIcon(MyTreeCellRenderer.class.getResource("images/task.gif")));
    Icons.put(new Integer(TreeMember.ntTASKDEGREE), new ImageIcon(MyTreeCellRenderer.class.getResource("images/degree.gif")));
    Icons.put(new Integer(TreeMember.ntTASKDISASTER), new ImageIcon(MyTreeCellRenderer.class.getResource("images/disaster.gif")));
    Icons.put(new Integer(TreeMember.ntTASKLOCATION), new ImageIcon(MyTreeCellRenderer.class.getResource("images/city.gif")));
    Icons.put(new Integer(TreeMember.ntTASKTRANSPORT), new ImageIcon(MyTreeCellRenderer.class.getResource("images/act_cfp_trans.png")));
    Icons.put(new Integer(TreeMember.ntTASKLOCATIONCFP), new ImageIcon(MyTreeCellRenderer.class.getResource("images/act_cfp_goods.png")));
    Icons.put(new Integer(TreeMember.ntTASKGOODS), new ImageIcon(MyTreeCellRenderer.class.getResource("images/goods.png")));
    Icons.put(new Integer(TreeMember.ntTASKTRANSPORTFAILURE), new ImageIcon(MyTreeCellRenderer.class.getResource("images/exclam.png")));
    Icons.put(new Integer(TreeMember.ntTASKBESTLEADER), new ImageIcon(MyTreeCellRenderer.class.getResource("images/act_trans_start.png")));
  }

  public MyTreeCellRenderer()
  {
  }

  public Component getTreeCellRendererComponent(
                        JTree tree,
                        Object value,
                        boolean sel,
                        boolean expanded,
                        boolean leaf,
                        int row,
                        boolean hasFocus)
  {

    super.getTreeCellRendererComponent(
                    tree, value, sel,
                    expanded, leaf, row,
                    hasFocus);

    if(value instanceof TreeMember)
    {
      ImageIcon icon= (ImageIcon)Icons.get(new Integer(((TreeMember)value).getNodeType()));
      if(icon!=null)
        setIcon(icon);
   }

//    return this;

    if (value instanceof VisData) {
      if (((VisData)value).isProgress()) {
        JProgressBar pb = new JProgressBar();
        pb.setString( ( (VisData) value).toString());
        pb.setStringPainted(true);
        pb.setMaximum(100);
        pb.setMinimum(0);
        //pb.setSize(20,8);
        double v = ((VisData)value).getProgressValue();
        pb.setValue((int)v);
        return pb;
      }
    }

    return this;
  }



}