/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.visual;

// JAVA imports
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

// MY imports

/**
 * <p><code>LegendWindow</code> shows the Color Key for colors used by agents.
 * It implements <code>ColorFactory.ColorFactoryListener</code> to get notified
 * of all color schema changes.</p>
 */

public class LegendWindow extends ToolWindow implements ColorFactory.ColorFactoryListener
{
  private Set _keys;

  JPanel contentPane;

  private JButton HideButton = new JButton();
  private JLabel GapFillerLabel = new JLabel();

  public LegendWindow()
  {
    super();
    setTitle("Color Key");
    _keys= new HashSet();
    ColorFactory.getDefaultFactory().registerColorFactoryListener(this);
  }

  /**
   * ColorFactorylistener implementation
   */
  public void updateKeys(Set newkeys)
  {
    if(!newkeys.containsAll(_keys)) // Schema has changed
    {
      _keys.clear();
      ContentPanel.removeAll();
    }
    else
      ContentPanel.remove(GapFillerLabel);

    Iterator i= newkeys.iterator();
    while(i.hasNext())
    {
      Object k= i.next();
      if(!_keys.contains(k))
      {
        if(k!=null)
        {
          JLabel color= getColorLabel(ColorFactory.getDefaultFactory().getKeyColor(k));
          JLabel label= new JLabel(k.toString());

          ContentPanel.add(color,     new GridBagConstraints(0, _keys.size(), 1, 1, 0.0, 0.0
              ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
          ContentPanel.add(label,         new GridBagConstraints(1, _keys.size(), 1, 1, 1.0, 0.0
              ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 5), 0, 0));
        }
        _keys.add(k);
      }
    }

    ContentPanel.add(GapFillerLabel,  new GridBagConstraints(0, _keys.size(), 1, 1, 0.0, 0.5
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

    ContentPanel.setSize(ContentPanel.getPreferredSize());
    revalidate();
  }

  private JLabel getColorLabel(Color c)
  {
    JLabel l= new JLabel();

    l.setBackground(c);
    l.setPreferredSize(new Dimension(15, 15));
    l.setOpaque(true);
    return l;
  }
}
