/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.visual;

// JAVA imports
import java.awt.GridBagConstraints;
import java.awt.Insets;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

// MY imports

/**
 * <p>
 * <code>IconWindow</code> is a simple <code>ToolWindow</code> displaying
 * key to icons used by structure trees and <code>AgentInfo</code>.</p>
 */

public class IconWindow extends ToolWindow
{
  private static final Insets IconInsets= new Insets(2, 5, 2, 5);
  private static final Insets LabelInsets= new Insets(0, 0, 0, 5);

  public IconWindow()
  {
    super();
    setTitle("Icon Key");
    initContents();
  }

  private void initContents()
  {
    addPair( ContentPanel, TreeMember.ntAGENT, "Agent", 0);
    addPair( ContentPanel, TreeMember.ntALLIANCE, "Alliance", 1);
    addPair( ContentPanel, TreeMember.ntTASK, "Task", 2);
    addPair( ContentPanel, TreeMember.ntCOALITION, "Coalition", 3);
    addPair( ContentPanel, TreeMember.ntCOALITIONLEADER, "Coalition Leader", 4);
    addPair( ContentPanel, TreeMember.ntAGENTTYPE, "Agent Type", 5);
    addPair( ContentPanel, TreeMember.ntAGENTCOUNTRY, "Country", 6);
    addPair( ContentPanel, TreeMember.ntAGENTCITY, "City", 7);
    addPair( ContentPanel, TreeMember.ntTASKDISASTER, "Disaster", 8);
    addPair( ContentPanel, TreeMember.ntTASKDEGREE, "Degree", 9);

    setSize(getPreferredSize());
    this.validate();
  }

  private void addPair(JPanel p, int type, String label, int row)
  {
    p.add(new JLabel((Icon)MyTreeCellRenderer.Icons.get(new Integer(type))),  new GridBagConstraints(0, row, 1, 1, 0.0, 0.0
          ,GridBagConstraints.CENTER, GridBagConstraints.NONE, IconInsets, 0, 0));
    p.add(new JLabel(label),  new GridBagConstraints(1, row, 1, 1, 0.0, 0.0
          ,GridBagConstraints.WEST, GridBagConstraints.VERTICAL, LabelInsets, 0, 0));
  }
}