/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.visual;

// JAVA imports
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

// MY imports

/**
 * <p><code>AllianceTreeModel</code> is a data model for bottom structure window
 * in the Visualizer window. The tree gives information on agents and alliances.</p>
 *
 * <p>This tree model mostly forwards the call to the tree node itself. To support
 * this all the object shown in the three impleent <code>TreeMember</code> interface.
 *
 * @see TaskTreeModel
 * @see TreeMember
 * @see VisAgent
 * @see VisAlliance
 * @see VisTask
 * @see VisString
 * @see VisCoalition
 * @see VisCoalitionLeader
 */

public class AllianceTreeModel implements TreeModel
{
  public final VisString ROOT = new VisString("ROOT", TreeMember.ntROOT);
  public final VisString AGENTROOT = new VisString("Agents", TreeMember.ntAGENTROOT);
  public final VisString ALLIANCEROOT = new VisString("Alliances", TreeMember.ntALLIANCEROOT);

  private List      _listeners;

  private List      _agents;
  private List      _alliances;

  public AllianceTreeModel(List agents, List alliances)
  {
    _listeners= new LinkedList();
    _agents= agents;
    _alliances= alliances;
  }

  public Object getRoot()
  {
    return ROOT;
  }

  public Object getChild(Object parent, int index)
  {
    if(parent==ROOT)
    {
      if(index==0)
        return AGENTROOT;
      else
        return ALLIANCEROOT;
    }
    else if(parent==AGENTROOT)
    {
      return _agents.get(index);
    }
    else if(parent==ALLIANCEROOT)
    {
      return _alliances.get(index);
    }
    else if(parent instanceof TreeMember)
      return ((TreeMember)parent).getChild(index);
    else
      return null;
  }

  public int getChildCount(Object parent)
  {
    if(parent==ROOT)
    {
      return 2;
    }
    else if(parent==AGENTROOT)
    {
      return _agents.size();
    }
    else if(parent==ALLIANCEROOT)
    {
      return _alliances.size();
    }
    else if(parent instanceof TreeMember)
      return ((TreeMember)parent).getChildCount();
    else
      return 0;
  }

  public boolean isLeaf(Object node)
  {
    if(node==ROOT)
    {
      return false;
    }
    else if(node==AGENTROOT)
    {
      return false;
    }
    else if(node==ALLIANCEROOT)
    {
      return false;
    }
    else if(node instanceof VisString)
      return true;
    else
      return false;
  }

  public void valueForPathChanged(TreePath path, Object newValue)
  {
    /**@todo: Implement this javax.swing.tree.TreeModel method*/
    throw new java.lang.UnsupportedOperationException("Method valueForPathChanged() not yet implemented.");
  }

  public int getIndexOfChild(Object parent, Object child)
  {
    if(parent==ROOT)
    {
      if(child==AGENTROOT)
        return 0;
      else
        return 1;
    }
    else if(parent==AGENTROOT)
    {
      return _agents.indexOf(child);
    }
    else if(parent==ALLIANCEROOT)
    {
      return _alliances.indexOf(child);
    }
    else if(parent instanceof TreeMember)
      return ((TreeMember)parent).getIndexOfChild(child);
    else
      return -1;
  }

  public void addTreeModelListener(TreeModelListener l)
  {
    _listeners.add(l);
  }

  public void removeTreeModelListener(TreeModelListener l)
  {
    if(_listeners.contains(l))
      _listeners.remove(l);
  }

  protected void fireTreeChange()
  {
    // Fire two events so the tree doesn't get packed
    TreeModelEvent e1= new TreeModelEvent(this, new Object [] {ROOT,AGENTROOT});
    TreeModelEvent e2= new TreeModelEvent(this, new Object [] {ROOT,ALLIANCEROOT});

    Iterator i= _listeners.iterator();
    while(i.hasNext())
    {
      TreeModelListener tml= (TreeModelListener)i.next();
      tml.treeStructureChanged(e1);
      tml.treeStructureChanged(e2);
    }
  }
}