/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.visual;

// JAVA imports
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.util.Iterator;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

// MY imports

/**
 * <p><code>AgentInfo</code> is a tooltip-like information window, that shows some
 * properties of an agent.</p>
 *
 * <p><code>AgentInfo</code> should be put into <code>LayeredPane</code> of its
 * owner. Whenever an action occurs (user clicks on an agent) <code>activate</code>
 * method should be called by the owner. It reads the info from the clicked agent
 * and shows the info.</p>
 *
 * @see Screen
 * @see VisAgent
 */

public class AgentInfoPanel extends JPanel
{
  private static final ImageIcon TYPE= new ImageIcon(MyTreeCellRenderer.class.getResource("images/type.gif"));
  private static final ImageIcon COUNTRY= new ImageIcon(MyTreeCellRenderer.class.getResource("images/country.gif"));
  private static final ImageIcon CITY= new ImageIcon(MyTreeCellRenderer.class.getResource("images/city.gif"));
  private static final ImageIcon TASK= new ImageIcon(MyTreeCellRenderer.class.getResource("images/task.gif"));

  private static final Insets IconInsets= new Insets(2, 5, 2, 5);
  private static final Insets LabelInsets= new Insets(0, 0, 0, 5);

  public static final AgentInfoPanel DefaultAgentInfo = new AgentInfoPanel();

  private GridBagLayout gridBagLayout1 = new GridBagLayout();
  private JLabel TypeIcon = new JLabel(TYPE);
  private JLabel TypeLabel = new JLabel();
  private JLabel CountryIcon = new JLabel(COUNTRY);
  private JLabel CountryLabel = new JLabel();
  private JLabel CityIcon = new JLabel(CITY);
  private JLabel CityLabel = new JLabel();
  private Border border1;

  public AgentInfoPanel(VisAgentInterface a)
  {
    this();
    setAgent(a);
  }

  public AgentInfoPanel()
  {
    try
    {
      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  public void activate(MouseEvent e)
  {
    if(e.getSource() instanceof VisAgentInterface)
    {
      VisAgentInterface a= (VisAgentInterface)e.getSource();
      Point l= ((JLabel)a).getLocationOnScreen();
      Point p= getParent().getLocationOnScreen();
      setAgent(a);
               //+20 so that the window is not under the mouse cursor
      setLocation(l.x+e.getX()-p.x, l.y+e.getY()-p.y+20);
      setVisible(true);
    }
  }

  public void deactivate(MouseEvent e)
  {
    setVisible(false);
  }

  public void setAgent(VisAgentInterface a)
  {
    this.removeAll();
    String tmp;
    int row= 0;

    tmp= a.getType();
    if(tmp!=null)
    {
      TypeLabel.setText(tmp);
      add(TypeIcon,  new GridBagConstraints(0, row, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, IconInsets, 0, 0));
      add(TypeLabel,  new GridBagConstraints(1, row, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.VERTICAL, LabelInsets, 0, 0));
      ++row;
    }

    tmp= a.getCountry();
    if(tmp!=null)
    {
      CountryLabel.setText(tmp);
      add(CountryIcon,  new GridBagConstraints(0, row, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, IconInsets, 0, 0));
      add(CountryLabel,  new GridBagConstraints(1, row, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.VERTICAL, LabelInsets, 0, 0));
      ++row;
    }

    tmp= a.getCity();
    if(tmp!=null)
    {
      CityLabel.setText(tmp);
      add(CityIcon,  new GridBagConstraints(0, row, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, IconInsets, 0, 0));
      add(CityLabel,  new GridBagConstraints(1, row, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.VERTICAL, LabelInsets, 0, 0));
      ++row;
    }

    Iterator i= a.getCoalitions().iterator();
    while(i.hasNext())
    {
      JLabel TaskLabel= new JLabel(((VisCoalition)i.next()).getTask().toString());
      add(new JLabel(TASK),  new GridBagConstraints(0, row, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, IconInsets, 0, 0));
      add(TaskLabel,  new GridBagConstraints(1, row, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.VERTICAL, LabelInsets, 0, 0));
      ++row;
    }
//    setBackground(SystemColor.info);
    setBackground(SystemColor.info);
    setSize(getPreferredSize());
//    this.setSize(new Dimension(200, 200));
    this.validate();
  }

  boolean alwaysOnTop()
  {
    return true;
  }

  private void jbInit() throws Exception
  {
//    contentPane= (JPanel)this.getContentPane();
    border1 = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black,1),BorderFactory.createEmptyBorder(3,0,3,0));
    this.setBackground(SystemColor.info);
    setBorder(border1);
    setLayout(gridBagLayout1);
    setOpaque(true);
//    this.setBackground(SystemColor.info);
//    TypeLabel.setText("jLabel2");
//    CountryLabel.setText("jLabel4");
//    CityLabel.setText("jLabel6");

//    this.add(CountryIcon,    new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
//            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 0, 5), 0, 0));
//    this.add(CountryLabel,    new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
//            ,GridBagConstraints.SOUTHWEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
//    this.add(CityIcon,    new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
//            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 0, 5), 0, 0));
//    this.add(CityLabel,    new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
//            ,GridBagConstraints.SOUTHWEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
  }
}