/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.ont;

// JAVA imports
import java.util.List;

// MY imports
//import aglobe.agent.visio.parser.*;

/**
 * <code>CoalitionDescription</code> is object representation of TASK/COALITION
 * used in VIEW message.
 *
 * @see cplantvis.MessageAnalyser
 * @see cplantvis.MessageAnalyserListener
 */

public class CoalitionDescription
{

  private String _taskname;
  private String _tasklocation;
  private String _taskdegree;
  private String _taskdisaster;

  private String _coalitionleader;
  private List   _coalitionmembers;

  /*public CoalitionDescription()
  {
  } */

  public CoalitionDescription(String coalitionLeader, List coalitionMembers, String degree, String disaster, String location, String name) {
    _taskname = name;
    _tasklocation = location;
    _taskdegree = degree;
    _taskdisaster = disaster;

    _coalitionleader = coalitionLeader;
    _coalitionmembers = coalitionMembers;
  }

  public String getCoalitionLeader()
  {
    return _coalitionleader;
  }

  public List getCoalitionMembers()
  {
    return _coalitionmembers;
  }

  public String getTaskDegree()
  {
    return _taskdegree;
  }

  public String getTaskDisaster()
  {
    return _taskdisaster;
  }

  public String getTaskLocation()
  {
    return _tasklocation;
  }

  public String getTaskName()
  {
    return _taskname;
  }

  /**
   * Just for testing.
   */
  /*public static void main(String[] args)
  {
    CoalitionDescription coalitionDescription1 = new CoalitionDescription();
  } */
}