/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio.ont;

// JAVA imports
import java.net.InetAddress;

// MY imports

/**
 * <code>AgentName</code> is small auxiliary class that encapsulates agent name
 * (surprise, surprise). It is used by <code>MTS</code> to get an IP address and
 * port of destination agents when sending messages (except of Facilitator, it
 * is addressed directly using it's <code>cfg</code> file).
 *
 * @see cplant.MTS
 */

public class AgentName
{
  private String        _shortname;
  private InetAddress   _ip;
  private int           _port;

  public AgentName(String name)
  {
    try
    {
//      _shortname= name.substring(0, name.indexOf('@'));
      _shortname = name;
//      String adr= name.substring(name.indexOf("://")+3);
//      _ip= InetAddress.getByName(adr.substring(0, adr.indexOf(':')));
//      _port= Integer.valueOf(adr.substring(adr.indexOf(':')+1, adr.indexOf("/"))).intValue();
    }
    catch(Exception e)
    { System.out.println("Unexpected exception: "+e); }
  }

  public String getName()
    { return _shortname; }

  public InetAddress getIP()
    { return _ip; }

  public int getPort()
    { return _port; }
}