/**
 * Title:        Visualizer for CPlanT
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Gerstner Laboratory, FEL-�VUT, Prague
 * @author Michal Dob�ek
 * @version 1.0
 */

package across.visio;
// JAVA imports
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import javax.swing.SwingUtilities;

import across.data.Batch;
import across.data.CoalitionDescription;
import across.data.Page;
import across.data.Proposal;
import across.data.RequestList;
import across.data.TeamProposal;
import across.data.TransportCfp;
import across.visio.oldvisio.VisioConnectionAgent;
import across.visio.ont.AllianceDescription;
import across.visio.ont.CPlantAgentDescription;
import across.visio.ont.DFAgentDescription;
import across.visio.visual.Screen;
import across.visio.visual.VisAgent;
import across.visio.visual.Visualizer;
import aglobe.container.agent.CMAgent;
import aglobe.container.transport.Address;
import aglobe.container.transport.ContainerRecord;
import aglobe.ontology.Message;
import aglobe.ontology.MessageConstants;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListener;



//import across.transporter.TransporterAgent;
/**
 * <p>
 * <code>VisualAgent</code> is the main class of CPlanT Visualizer.
 * </p>
 * <p>
 * Is's main method has two parameters<br>
 * <ol>
 *   <li><code>Facilitator-cfg-file</code> (required)</li>
 *   <li><code>Visual-config-file</code> (optional)</li>
 * </ol>
 * </p>
 * <p>
 * Example:
 * <code>javaw -cp aglobe.agent.visio.jar cplant.VisualAgent C:/MYCPLANTPATH/lisp-facilitator.cfg Config.xml</code>

 * </p>
 * <p>

 * <code>VisualAgent</code> constructs the whole message processing chain<br>
 * <code><strong>MTS</strong></code> ->
 * <code><strong>MessageQueue</strong></code> ->
 * <code><strong>MessageAnalyser</strong></code> ->
 * <code><strong>VisualAgent</strong></code> ->
 * <code><strong>Visualizer</strong></code><br>

 * When everithing is set-up, <code>VisualAgent</code> registers with Facilitator.
 * To quit the application, call <code>quit()</code>. This call deregisters from
 * Facilitator and shuts down the whole message processing chain.
 * </p>
 */





public class VisualAgent extends CMAgent implements MessageConstants,//, MessageProtocols,
GISTopicServerListener//, GISVisibilityListener


//public class VisualAgent implements CONSTANTS, PARSERCONST, MessageAnalyserListener

{


  /**
     * Topic used for updating logic-visio task tree. In the content is TransportBatch object.
     */
   // public final static String TOPIC_TRANSPORT_CFP = "TRANSPORT_CFP";

    /**
     * Topic used for updating logic-visio task tree. In the content is Set of coalition
     * member adresses.
     */


  public final static String TOPIC_NEW_COALITION = "NEW_COALITION";
  public static final String TOPIC_LOCATION_CFP_AND_PARTICIPANTS = "LOCATION_CFP_AND_PARTICIPANTS";
  public static final String TOPIC_LOCATION_RECEIVED_OFFER = "LOCATION_RECEIVED_OFFER";
  public static final String TOPIC_LOCATION_WINNER = "LOCATION_WINNER";
  public static final String TOPIC_LOCATION_REFUSED = "LOCATION_REFUSE";
  public static final String TOPIC_ACCEPTATION_RECEIVED = "ACCEPTATTION_RECEIVED";
  public static final String TOPIC_TEAM_MEMBER_PROPOSAL = "TEAM_MEMBER_PROPOSAL";
  public static final String TOPIC_TEAM_LEADER_PROPOSAL = "TEAM_LEADER_PROPOSAL";
  public static final String TOPIC_BEST_LEADER = "BEST_LEADER";
  public static final String TOPIC_COALITION_FINISHED = "COALITION_FINISHED";



  private static Config Configuration;
  static private String VISUALIZER = "Visio";
  private boolean _quitting= false;
  int         _replywith= 0;
  public String      _name = "Visual Agent";
  boolean     _down= false;
  public List citiesList = new LinkedList();
  private aglobe.ontology.AgentInfo aInfo = new aglobe.ontology.AgentInfo();
  private across.data.PublicParams publicParams = new across.data.PublicParams();
//  private Location location = new Location();
  private Visualizer visualizer;
  private List knownPlatforms = new LinkedList(); // list of PlatformRecord

  private Set knownAgents = new HashSet(); // list of String agentName
  private java.util.Map fullNames = new HashMap();

  private GISServerService.Shell gisShell;

  private java.util.Map transportBatchesById = new HashMap();
  private java.util.Map locationBatches = new HashMap();
  private java.util.Map locationBatchesById = new HashMap();
  private java.util.Map locationNames = new HashMap();

  private java.util.Map refused = new HashMap();
  private java.util.Map receivedAcceptation = new HashMap();
  private java.util.Map bestProposals = new HashMap();

  private java.util.Map coalitions = new HashMap();


  public Screen gui;



// ----------------------------------

  /**
   * List of aliances:
   *   key - String - alliance name (pp.getAlliance);
   *   value - AllianceDescription -list of agents in alliance
   */

  private java.util.Map alliances = new HashMap();
  java.util.Map visualPages = new HashMap();


  public VisualAgent()
  {
    try {
      Configuration = new Config("xml/alianvisiocfg.xml");
    }
    catch (IOException ex) {
    }
  }

  public void init(aglobe.ontology.AgentInfo a, int initState) {
    super.init(a, initState);
    aInfo = a;

    visualizer= new Visualizer(this);
    gui = visualizer.getScreen();

    publicParams.setType("logickeVisio");

   gisShell = (GISServerService.Shell)getContainer().getServiceManager().getService(this,GISServerService.SERVICENAME);
   if (gisShell == null) {
     logger.severe("GISServerService not running");
     stop();
     return;
   }
   gisShell.subscribeTopic(VisioConnectionAgent.TOPIC_PAGE_UPDATE, this);
   gisShell.subscribeTopic(TOPIC_NEW_COALITION, this);
   gisShell.subscribeTopic(TOPIC_TEAM_LEADER_PROPOSAL, this);
   gisShell.subscribeTopic(TOPIC_LOCATION_CFP_AND_PARTICIPANTS, this);
   gisShell.subscribeTopic(TOPIC_LOCATION_RECEIVED_OFFER, this);
   gisShell.subscribeTopic(TOPIC_LOCATION_WINNER, this);
   gisShell.subscribeTopic(TOPIC_LOCATION_REFUSED, this);
   gisShell.subscribeTopic(TOPIC_ACCEPTATION_RECEIVED, this);
   gisShell.subscribeTopic(TOPIC_TEAM_MEMBER_PROPOSAL, this);
   gisShell.subscribeTopic(TOPIC_BEST_LEADER, this);
   gisShell.subscribeTopic(TOPIC_COALITION_FINISHED, this);
  }



  public void newVisibleUpdateSet(List newSet) {
//    dlog("Starting visibility change ...");

    newSet.removeAll(knownPlatforms);
//    dlog("New Visibile platforms ...");
    for (Iterator it = newSet.iterator(); it.hasNext(); ) {
      ContainerRecord pr = (ContainerRecord) it.next();
//      dlog("... " + pr.name);
// petr      new TaskSubscribe(cm, this, pr.address);
 // @todo     new TaskSubscribe(this, pr.address);

    }
    knownPlatforms.addAll(newSet);
//    dlog("Invisibility change done.");
  }




  private boolean isVisible(List visPlatforms, across.data.Page agent) {
    for (Iterator it = visPlatforms.iterator(); it.hasNext(); ) { //projdu vsechny viditelne platformy
      ContainerRecord pr = (ContainerRecord) it.next();
      Address addr = agent.getAddress();

      Address platformAddr = Address.getContainerAddress(addr.getHost(), addr.getPort(), addr.getContainerName());

      if (platformAddr.equals(pr.address)) { //aktualni agent je zrovna videt
        visualizer.setVisibility(agent.getName(), true);
        return true;
      }
    }
    return false;
  }



  public static Config getConfig()
  {
    return Configuration;
  }

  public void quit() {
    shutdown();
    kill();
  }

  public void shutdown() {
    visualizer.shutdown();
    _down = true;
    Screen s = visualizer.getScreen();
    if (s != null) {
      s.dispose();
    }
  }

  public int getReplyWith()
  {
    return ++_replywith;
  }


  public String getFullNameByType(String type) {
    for (Iterator it = visualizer._agents.iterator(); it.hasNext();) {
      VisAgent va = (VisAgent)it.next();
      if (va.getType().equalsIgnoreCase(type))
        return va.getName();
    }
    throw new IllegalArgumentException("Unknown type: "+type);
  }



  /**
   * The MessageAnalyserListener interface implementation
   */

  public void registerAgent(final DFAgentDescription dfad, final CPlantAgentDescription cpad)
  {
    visualizer.registerAgent(dfad, cpad);
  }

  public static String getPageValue(Page page, String paramName) {
    return getParamValue(page.getPublicParams().getParam(), paramName);
  }

  public static String getAlliance(Page page) {
     String alliance = getPageValue(page, "alliance-name");
     /** @todo hack to show correctly RCTransporters */
     if (alliance == null) {
       alliance = "no-alliance";
     }
     return alliance;
   }

   /**
    * returns the value of <code>paramName</code> in <code>params</code> list
    * @param params List of Param
    * @param paramName String
    * @return String param value, null if not found
    */
   public static String getParamValue(List params, String paramName) {
     for (Iterator iter = params.iterator();
          iter.hasNext(); ) {
       across.data.Param param = (across.data.Param) iter.next();

       if (paramName.equalsIgnoreCase(param.getName())) {
         return param.getValue();
       }
     }
     return null;
   }


 public void removeEmptyAlliances() {
   for (Iterator i = alliances.keySet().iterator(); i.hasNext();) {
     String key = (String)i.next();

     AllianceDescription ad = (AllianceDescription)alliances.get(key);
     if (ad.getMembers().size() == 0) {
       alliances.remove(key);
     }
   }
 }

  public void registerAgent(across.data.Page p) {

    Page previous = (Page)visualPages.get(p.getName());
    if (previous != null) {
      if (!getAlliance(previous).equalsIgnoreCase(getAlliance(p))) {

        AllianceDescription alliDesc = (AllianceDescription) alliances.get(
            getAlliance(previous));
        List members = alliDesc.getMembers();
        members.remove(p.getName());

      }
    }


      registerAgent(new DFAgentDescription (p.getName(), getParamValue(p.getPublicParams().getParam(), "tribe"), "no owner"), // todo type
                    new CPlantAgentDescription (p.getName(),getParamValue(p.getPublicParams().getParam(), "location") ,getParamValue(p.getPublicParams().getParam(), "region"))); // todo: location,country
      String alli = getAlliance(p);
      if (alli != null) {
        AllianceDescription alliDesc = (AllianceDescription) alliances.get(alli);
        if (alliDesc == null) {
          List list = new LinkedList();
          list.add(p.getName());
          alliDesc = new AllianceDescription();
          alliDesc.setMembers(list);
          alliDesc.setName(alli);
          alliances.put(alli, alliDesc);
        }
        else {
          alliDesc.getMembers().add(p.getName());
        }
        newAlliance(alliDesc);


      }

    if (knownAgents.contains(p.getName())) return;

    fullNames.put(p.getAddress(), p.getName());
    knownAgents.add(p.getName());
    visualPages.put(p.getAddress(), p);
  }


  public void deregisterAgent(final DFAgentDescription dfad) {
    visualizer.deregisterAgent(dfad);
  }



  public void newAlliance(final AllianceDescription ad) {
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        try {
          visualizer.newAlliance(ad);
        }
        catch (Exception ex) {
          ex.printStackTrace();
        }
      }
    });
  }


  private void newCoalition(final CoalitionDescription cd,  String locationInitiatorName, String id) //, String bestTransporter)
  {
    if ((cd == null) || (locationInitiatorName == null)) { //|| (bestTransporter ==  null)) {
      System.out.println("cd "+cd);
      System.out.println("locationName "+locationInitiatorName);
//      System.out.println("bestTransporter "+bestTransporter);
      return;
     }

     if (visualizer.newCoalition(cd, locationInitiatorName, visualizer.parseId(id, 0), visualizer.parseId(id, 1))) {
       coalitions.remove(id);
     } else { System.out.println("coalition wasn't displayed");
     }
   }


  public void dlog(String str) {
    System.out.println(str);
  }

  int iniMessagesNo = 0;
  public void incIniMessCount()
  {
    iniMessagesNo++;
  }

  //int coalNum = 1;




/*  private String getAlliance(String name) {
    for (Iterator i = visualPages.keySet().iterator(); i.hasNext();) {
      Page p = (Page)visualPages.get((Address)i.next());
      if (name.equals(p.getName()))
        return getAlliance(p);
    }
    return null;
  } */


  /**
   * Returns all agents from allAgents, that are in the same alliance as agent name
   * @param name
   * @param allAgents list of Strings - fullnames
   * @return
   */

/*  private List getTeamMembers(String name, List allAgents) {
    List members = new LinkedList();
    String alliance = getAlliance(name);

    for (Iterator it = allAgents.iterator(); it.hasNext(); ) {
      String actName = (String)it.next();
      String actAlliance = getAlliance(actName);
      if (alliance.equals(actAlliance))
        members.add(actName);
    }
    return members;
  } */

  public String getFullName(String name) {
    return (String) fullNames.get(name);
  }

 public void handleLoginTopic(String topic, String remoteContainerName,
                              Address remoteContainerAddress) {
   return;
 }

 public void handleLogoutTopic(String topic, String remoteContainerName) {
   return;
 }


 public void handleTopic(String topic, Object content, String reason,
                        String remoteContainerName,
                        Address remoteClientAddress) {

  if (topic.equalsIgnoreCase(VisioConnectionAgent.TOPIC_PAGE_UPDATE)) {
    final Page p = (Page) content;
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        registerAgent(p);
      }
    });
  }


  if (topic.equalsIgnoreCase(TOPIC_NEW_COALITION)) {
    List data = (List) content;
    coalitions.put( (String) data.get(0), (CoalitionDescription) data.get(1));

  }
  if (topic.equalsIgnoreCase(TOPIC_TEAM_LEADER_PROPOSAL)) {
    List data = (List) content;
    Proposal p = (Proposal) data.get(0);


    TransportCfp tcfp = (TransportCfp) data.get(1);
    String transporter = (String) data.get(2);
    Proposal myProposal = (Proposal) data.get(3);
    TeamProposal teamProposal = (TeamProposal) data.get(4);

    if (visualizer.parseId(tcfp.getRequestid(), 2) == null) {
      addTransportLeaderProposal(p, transporter, tcfp, myProposal, teamProposal);
    } else {
      // subcontract
      String transporterInitiator = visualizer.parseId(tcfp.getRequestid(), 2);
      tcfp.setRequestid(visualizer.parseId(tcfp.getRequestid(),0));
      p.setRequestid(visualizer.parseId(p.getRequestid(), 0));
      addTransportLeaderSubcontractProposal(p, transporter, tcfp, transporterInitiator, myProposal, teamProposal);
     }
  }
  if (topic.equalsIgnoreCase(TOPIC_LOCATION_CFP_AND_PARTICIPANTS)) {
    addLocationCFP( (List) content);
  }

  if (topic.equalsIgnoreCase(TOPIC_LOCATION_RECEIVED_OFFER)) {
    newLocationOffer( (List) content);
  }

  if (topic.equalsIgnoreCase(TOPIC_LOCATION_WINNER)) {
    locationWinner( (Message) content);
  }

  if (topic.equalsIgnoreCase(TOPIC_LOCATION_REFUSED)) {
    locationRefused( (Message) content);
  }

  if (topic.equalsIgnoreCase(TOPIC_ACCEPTATION_RECEIVED)) {
    acceptationReceived( (Message) content);
  }

  if (topic.equalsIgnoreCase(TOPIC_TEAM_MEMBER_PROPOSAL)) {
    List data = (List) content;
    Proposal p = (Proposal) data.get(0);
     if (p != null) {
       if (visualizer.parseId( p.getRequestid(), 2) == null) {
         TeamProposal tp = (TeamProposal) data.get(1);

         String locationInitiator = visualizer.parseId(p.getRequestid(), 1);
         String proposer = (String) data.get(2);
         visualizer.addTeamMemberProposal(p, proposer, locationInitiator, tp, locationNames,
                                         locationBatches);

       }
       else {
         // subcontract
         TeamProposal tp = (TeamProposal) data.get(1);
         String transporterInitiator = visualizer.parseId(p.getRequestid(), 2);
         String proposer = (String) data.get(2);
         tp.getTransportCfp().setRequestid(visualizer.parseId(tp.getTransportCfp().getRequestid(), 0));
         visualizer.addTeamMemberSubcontractProposal(p, proposer, transporterInitiator, tp, locationNames,
                                         locationBatches);
       }
     }
  }

  if (topic.equalsIgnoreCase(TOPIC_BEST_LEADER)) {
    List data = (List) content;
    TransportCfp cfp = (TransportCfp) data.get(0);
    String name = (String) data.get(1);
    if (visualizer.parseId(cfp.getRequestid(), 2) == null) {
      String locationInitiator = visualizer.parseId(cfp.getRequestid(), 1);
      visualizer.setBestLeader(cfp, name, locationInitiator, locationNames);

      CoalitionDescription cd = (CoalitionDescription) coalitions.get(cfp.getRequestid());
      if (cd != null) {
        newCoalition(cd,
                      (String) locationNames.get(visualizer.parseId(cfp.getRequestid(),0)),
                      cfp.getRequestid());
      }
      else {
        // System.out.println("object cd null");
      }

    } else {
        // subcontract
      String transporterInitiator = visualizer.parseId(cfp.getRequestid(), 2);
      visualizer.setBestSubcontractLeader(cfp, name, transporterInitiator, locationNames);

      CoalitionDescription cd = (CoalitionDescription) coalitions.get(cfp.getRequestid());
      if (cd != null) {
        newCoalition(cd,
                      (String) locationNames.get(visualizer.parseId(cfp.getRequestid(),0)),
                      cfp.getRequestid());
      }
    }
  }

  if (topic.equalsIgnoreCase(TOPIC_COALITION_FINISHED)) {
   // String id = visualizer.parseId((String)content, 0);
    visualizer.finishCoalition((String)content, locationNames);
  }


}


private void addTransportLeaderProposal(Proposal prop, String name, TransportCfp cfp, Proposal myProposal, TeamProposal teamProposal) {
 visualizer.addTransporLeaderProposal(prop, name, cfp, transportBatchesById, locationNames, locationBatches, myProposal, teamProposal);
}
  private void addTransportLeaderSubcontractProposal(Proposal prop, String name, TransportCfp cfp, String transporterInitiator, Proposal myProposal, TeamProposal teamProposal) {
   visualizer.addTransportLeaderSubcontractProposal(prop, name, transporterInitiator, cfp, transportBatchesById, locationNames, locationBatches, myProposal, teamProposal);
  }

  private void addLocationCFP(List data) {
    RequestList requestList = (RequestList)data.get(0);
    Collection participants = (Collection)data.get(1);
    String name = (String)data.get(2);

    if (locationBatches.get(requestList.getRequestid()) == null) {
      locationNames.put(requestList.getRequestid(), name);

      visualizer.newLocCFPRequest(requestList, participants, name);
      locationBatches.put(requestList.getRequestid(), requestList.getBatch());

      for (Iterator i = requestList.getBatch().iterator(); i.hasNext();) {
        Batch b = (Batch)i.next();
        locationBatchesById.put(Long.toString(b.getBatchid()), b);
      //  System.out.println(requestList.getRequestid()+": "+b.getComodityName()+" = "+b.getCount());
      }

      Message m;
      m = (Message)bestProposals.get(requestList.getRequestid());
      if (m != null) {
       name =  m.getSender().getName();
       Proposal bestProposal = (Proposal)m.getContent();
       if (visualizer.bestLocationOffer(name, bestProposal, (String)locationNames.get(bestProposal.getRequestid()))) {
         bestProposals.remove(requestList.getRequestid());
       }
      }
      m = (Message)refused.get(requestList.getRequestid());
      if (m != null) {
        String refusingLocation = m.getReceiver().getName();
        RequestList rl = (RequestList)(m.getContent());
        visualizer.locationRefused(refusingLocation, rl.getRequestid(), (String)locationNames.get(rl.getRequestid()));
        refused.remove(rl.getRequestid());
      }
      m = (Message)receivedAcceptation.get(requestList.getRequestid());
      if (m != null) {
        RequestList rl = (RequestList)m.getContent();
        name = m.getReceiver().getName();
        visualizer.acceptationReceived(name, rl.getRequestid(), (String)locationNames.get(rl.getRequestid()));
        receivedAcceptation.remove(requestList.getRequestid());
      }

    } else { this.logger.warning("two location contracts has the same requestID");
       //System.out.println("again: "+name+" id: "+requestList.getRequestid());
     }
  }

  private void newLocationOffer(List data) {
     Proposal proposal = (Proposal)data.get(0);
     String locationName = (String)data.get(1);
//     System.out.println("Location "+locationName+" proposed: "+proposal);
     visualizer.newLocationOffer(proposal, locationName, locationBatchesById, (String)locationNames.get(proposal.getRequestid()));
  }

  private void locationWinner(Message m) { //String name, Proposal bestProposal) {
    String name = m.getSender().getName();
    Proposal bestProposal = (Proposal) m.getContent();
    if (!visualizer.bestLocationOffer(name, bestProposal,
                                      (String) locationNames.
                                      get(bestProposal.getRequestid()))) {
      bestProposals.put(bestProposal.getRequestid(), m);
    }
  }

  private void locationRefused(Message m) {
    String refusingLocation = m.getReceiver().getName();
    RequestList requestList = (RequestList)(m.getContent());
    if (locationBatches.get(requestList.getRequestid()) == null) {
      refused.put(requestList.getRequestid(), m);
    } else {
        visualizer.locationRefused(refusingLocation, requestList.getRequestid(), (String)locationNames.get(requestList.getRequestid()));
    }
  }
  private void acceptationReceived(Message m) {
    RequestList requestList = (RequestList)m.getContent();
    String name = m.getReceiver().getName();

    if (locationBatches.get(requestList.getRequestid()) == null) {
      receivedAcceptation.put(requestList.getRequestid(), m);
    } else {
       visualizer.acceptationReceived(name, requestList.getRequestid(), (String)locationNames.get(requestList.getRequestid()));
      }
  }

 }
