package across.util.skn.util.membership.iterative;

import across.util.skn.util.FuzzySet;
import across.util.skn.util.membership.FuzzyNumberMembership;
import across.util.skn.util.membership.IterativeFuzzyMembership;
import across.util.skn.util.membership.Point;

/**
 * This membership is 1 until min or avg - sigmaHalf, 0 from avg.
 */
public class UnderAvgMembership<MemberObject> extends FuzzyNumberMembership<MemberObject>
{
    public UnderAvgMembership(MemberObject member, FuzzySet set) {
        super(member, set);
        points.add(new Point(0,1));
        points.add(new Point(0,1));
        points.add(new Point(0.5,0));
    }

    public UnderAvgMembership(IterativeFuzzyMembership<MemberObject> trust) {
		super(null,null);
		points.add(new Point(0,0));
        points.add(new Point(0.5,1));
        points.add(new Point(1,1));
        setData(trust);
	}

	/**
     * This method reads the sequence properties and modifies the points array of the FuzzyNumberMembership class.
     */
    public void applyChangesToShape() {
        double sigma = Math.sqrt(getVariance());
        points.get(0).setXY(0,1);
        points.get(1).setXY(Math.max(avg - sigma, min),1);
        points.get(2).setXY(avg,0);
    }
}
