package across.util.skn.util.membership.iterative;

import across.util.skn.util.FuzzySet;
import across.util.skn.util.membership.FuzzyNumberMembership;
import across.util.skn.util.membership.Point;

/**
 * Integrates Sigma and Min/max values with n value.
 */
public class SigmaMinMaxMembership<MemberObject> extends FuzzyNumberMembership<MemberObject>
{
    public SigmaMinMaxMembership(MemberObject memberObject, FuzzySet set)
    {
        super(memberObject, set, (Point[])null);
        points.add(new Point(0,0));
        points.add(new Point(0,1));
        points.add(new Point(0.5,1));
        points.add(new Point(1,1));
        points.add(new Point(1,0));
    }

    public void applyChangesToShape()
    {
        double sigma = Math.sqrt(getVariance());
        points.get(0).setXY( min, 0);
        points.get(1).setXY(Math.max(avg - sigma, min),1.0/(n+1));
        points.get(2).setXY(avg,1);
        points.get(3).setXY(Math.min(avg + sigma, max),1.0/(n+1));
        points.get(4).setXY(max, 0);
    }
}
