package across.util.skn.util.membership.iterative;

import sun.reflect.generics.reflectiveObjects.NotImplementedException;
import across.data.trust.AgentTrustfulness;
import across.util.skn.util.membership.FuzzyNumberMembership;
import across.util.skn.util.membership.IterativeFuzzyMembership;
import across.util.skn.util.membership.SimpleFuzzyMembership;

/**
 * This class defines two fuzzy intervals with sum = 1. Lower core limit of the upper interval is avg...
 * Note that this does not defien a membership - it is inherited from it only to be comparable...
 */
public class IterativeTwoCategories extends IterativeFuzzyMembership
{
    // membership that is one above avg
    AboveAvgMembership<Object> high = new AboveAvgMembership<Object>(null, null);
    // membership complementary to high - their sum is 1 - they are a partition of 1...
    UnderAvgMembership<Object> low = new UnderAvgMembership<Object>(null, null);

    public IterativeTwoCategories() {
        super(null, null);
    }

    public IterativeTwoCategories(IterativeFuzzyMembership trust) {
		super(null, null);
		super.setData(trust);
		high = new AboveAvgMembership(trust);
		low = new UnderAvgMembership(trust);
	}

	/**
     * This function is called when new sample is observed.
     * Updates the properties of the sequence.
     *
     * @param value observed value of the sample
     */
    public void newSample(double value)
    {
        super.newSample(value);
        high.newSample(value);
        low.newSample(value);
    }

    @Override
	public void setData(AgentTrustfulness agt) {
		high.setData(agt);
		low.setData(agt);
	}

	public boolean isHigherThanLower(IterativeFuzzyMembership trustedEntity)
    {
        if (trustedEntity instanceof FuzzyNumberMembership)
        {
            return isHigherThanLower((FuzzyNumberMembership)trustedEntity);
        }
        else if (trustedEntity instanceof SimpleFuzzyMembership)
        {
            return isHigherThanLower((SimpleFuzzyMembership)trustedEntity);
        }
        throw new ClassCastException("Can not compute the intersection with this membership type.");
    }

    public boolean isHigherThanLower(SimpleFuzzyMembership trustedEntity)
    {
        double highIntersection = high.getIntersectionHeight(trustedEntity);
        double lowIntersection = low.getIntersectionHeight(trustedEntity);
        if (highIntersection >= lowIntersection)
        {
            return true;
        }
        return false;
    }

    public boolean isHigherThanLower(FuzzyNumberMembership trustedEntity)
    {
        double highIntersection = high.getIntersectionHeight(trustedEntity);
        if (1 == highIntersection)
        {
            return true; // can not have higher than 1 - no need to compute the lower incidence...
        }
        double lowIntersection = low.getIntersectionHeight(trustedEntity);
        //System.out.println(" high: " + highIntersection + " low: " + lowIntersection);
        if (highIntersection >= lowIntersection)
        {
            return true;
        }
        return false;
    }

    public AboveAvgMembership getHigh()
    {
        return high;
    }

    public UnderAvgMembership getLow()
    {
        return low;
    }

    /**
     * Do nothing here, it is done in newSample for embedded numbers
     */
    public void applyChangesToShape() {

    }

    /**
     * Compares this value with a number whose X values were shifted by multiplication with coeff with the other one.
     * Note that by multiplication with coeff smaller than 1 we shrink the uncertainity and vice versa.
     *
     * @param coeff coefficient used to multiply the x values of the current number
     * @param other membership function to compare with
     * @return 1 if bigger than other, -1 if smaller than other, 0 if incomparable or equivalent
     */
    public int compareWithCoefficient(double coeff, IterativeFuzzyMembership other)
    {
        throw new NotImplementedException();
    }

    /**
     * @param o the Object to be compared.
     * @return a negative integer, zero, or a positive integer as this object
     *         is less than, equal to, or greater than the specified object.
     * @throws ClassCastException if the specified object's type prevents it
     *                            from being compared to this Object.
     */
    public int compareTo(Object o)
    {
        throw new NotImplementedException();
    }

    /**
     * Returns true if incidence with the set is nonzero, i.e. if membership function is not zero for this member.
     */
    public boolean isMember()
    {
        throw new NotImplementedException();
    }

    /**
     * Returns true if incidence with the core of the set is nonzero, i.e. if membership function is maximum, typically 1
     */
    public boolean isCoreMember()
    {
        throw new NotImplementedException();
    }

    /**
     * Returns the center of the membership function.
     *
     * @return center of the function, shape specific. Bounded to [0,1] interval.
     */
    public double getMembershipFunctionCenter()
    {
        throw new NotImplementedException();
    }

    /**
     * Returns the uncertainity of the membership function.
     */
    public double getMembershipFunctionUncertainity()
    {
        throw new NotImplementedException();
    }
}
