package across.util.skn.util.membership.iterative;

import across.util.skn.util.FuzzySet;
import across.util.skn.util.membership.FuzzyNumberMembership;
import across.util.skn.util.membership.IterativeFuzzyMembership;
import across.util.skn.util.membership.Point;

/**
 * This membership is o until min or avg - sigmaHalf, 1 from avg until 1.
 */
public class AboveAvgMembership<MemberObject> extends FuzzyNumberMembership<MemberObject>
{
     public AboveAvgMembership(MemberObject member, FuzzySet set) {
        super(member, set);
        points.add(new Point(0,0));
        points.add(new Point(0.5,1));
        points.add(new Point(1,1));
    }

    public AboveAvgMembership(IterativeFuzzyMembership<MemberObject> trust) {
		super(null,null);
		points.add(new Point(0,0));
        points.add(new Point(0.5,1));
        points.add(new Point(1,1));
        setData(trust);
	}

	/**
     * This method reads the sequence properties and modifies the points array of the FuzzyNumberMembership class.
     */
    public void applyChangesToShape() {
        double sigma = Math.sqrt(getVariance());
        points.get(0).setXY(Math.max(avg - sigma, min),0);
        points.get(1).setXY(avg,1);
    }
}
