package across.util.skn.util.membership;

import across.util.skn.util.FuzzySet;

/**
 * Created by IntelliJ IDEA.
 * User: rehakm1
 * Date: 14.10.2004
 * Time: 15:39:10
 * To change this template use File | Settings | File Templates.
 */
public class SimpleFuzzyMembership<MemberObject> extends IterativeFuzzyMembership<MemberObject>
{

    double membership;

    public double getMembership() {
        return membership;
    }

    public void setMembership(double membership) {
        this.membership = membership;
    }

    public boolean isMember() {
        if (membership > 0) return true;
        return false;
    }

    /**
     * Returns true if incidence with the core of the set is nonzero, i.e. if membership function is maximum, typically 1
     */
    public boolean isCoreMember() {
        if (membership == 1) return true;
        return false;
    }

    /**
     * Returns the center of the membership function.
     * @return center of the function, shape specific. Bounded to [0,1] interval.
     */
    public double getMembershipFunctionCenter() {
        return membership;
    }

    /**
     * Returns the uncertainity of the membership function.
     * The uncertainity is zero for this type, there is no specific representation.
     */
    public double getMembershipFunctionUncertainity() {
        return 0;
    }

    public SimpleFuzzyMembership(MemberObject member, FuzzySet set) {
        super(member, set);
    }
    /**
     * In this case, shape is a dirac-like peak.
     */
    public void applyChangesToShape() {
        membership = avg;
    }

    /**
     * Compares this value with a number whose X values were shifted by multiplication with coeff with the other one.
     * Note that by multiplication with coeff smaller than 1 we shrink the uncertainity and vice versa.
     *
     * @param coeff coefficient used to multiply the x values of the current number
     * @param other membership function to compare with
     * @return 1 if bigger than other, -1 if smaller than other, 0 if incomparable or equivalent
     */
    public int compareWithCoefficient(double coeff, IterativeFuzzyMembership other)
    {
        double omem = ((SimpleFuzzyMembership)other).membership;
        if (membership*coeff == omem)
        {
            return 0;
        }
        else if ( membership*coeff > omem)
        {
            return 1;
        }
        return -1;
    }

    /**
     * "Note: this class has a natural ordering that is
     * inconsistent with equals."
     * @param o the Object to be compared.
     * @return a negative integer, zero, or a positive integer as this object
     *         is less than, equal to, or greater than the specified object.
     * @throws ClassCastException if the specified object's type prevents it
     *                            from being compared to this Object.
     */
    public int compareTo(Object o) {
        if (o instanceof SimpleFuzzyMembership)
        {
            double omem = ((SimpleFuzzyMembership)o).getMembership();
            if (membership == omem)
            {
                return 0;
            }
            else if ( membership > omem)
            {
                return 1;
            }
            return -1;
        }
        throw new ClassCastException("Cannot compare with incompatible membership function.");
    }
}
