package across.util.skn.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import across.util.skn.AgentKnowledge;
import aglobe.container.transport.Address;

/**
 * This class contains methods that manipulate lists of AgentKnowledge objects.
 * It is used for implementation of different skn higher-level methods.
 */
public class AgentListTools
{
    /**
     * Returns randomly picked agent from the list.
     * @param agentList list to chose the agent from
     * @return AgentKnowledge structure, null if null list or no elements in the list
     */
    public static AgentKnowledge pickRandomAgent(List<AgentKnowledge> agentList)
    {
        if (null != agentList && 0 < agentList.size())
        {
            long rand = Math.round(Math.random() * agentList.size());
            return agentList.get((int)rand);
        }
        return null;
    }
    /**
     * Returns agent with best preference from the list
     * @param agentList list to chose the agent from
     * @return AgentKnowledge structure, null if null list or no elements in the list
     */
    public static AgentKnowledge pickMostRelevantAgent(Collection<AgentKnowledge> agentList)
    {
        AgentKnowledge res = null;
        if (null != agentList && 0 < agentList.size())
        {
            Iterator<AgentKnowledge> iterator = agentList.iterator();
            res =  iterator.next();
            for (; iterator.hasNext();)
            {
                AgentKnowledge cak = iterator.next();
                if (res.getInterest() < cak.getInterest())
                {
                    res = cak;
                }
            }
        }
        return res;
    }

    /**
     * Returns all accessible agents from the list, except the agent to exclude passed in the param agentToAvoid.
     * @param agentList list to chose the agents from
     * @param agentToAvoid agent to remove from the list (for example the caller.) May be null.
     * @return List of AgentKnowledge structures
     */
    public static Collection<AgentKnowledge> getAccessibleAgents(Collection<AgentKnowledge> agentList, Address agentToAvoid)
    {
        List<AgentKnowledge> res = new LinkedList<AgentKnowledge>();
        if (null != agentList)
        {
            for (Iterator<AgentKnowledge> oit = agentList.iterator(); oit.hasNext();)
            {
                AgentKnowledge agent = oit.next();
                if (null != agent.container && agent.isAccessible() && agentToAvoid != agent.address)
                {
                    res.add(agent);
                }
            }
        }
        return res;
    }
    /**
     * Returns all accessible agents from the list, except the agent to exclude passed in the param agentToAvoid.
     * @param agentList list to chose the agents from
     * @param agentToAvoid agent to remove from the list (for example the caller.) May be null.
     * @return List of Address objects
     */
    public static Collection<Address> getAccessibleAgentsAddress(Collection<AgentKnowledge> agentList, Address agentToAvoid)
    {
        List<Address> res = new LinkedList<Address>();
        if (null != agentList)
        {
            for (Iterator<AgentKnowledge> oit = agentList.iterator(); oit.hasNext();)
            {
                AgentKnowledge agent = oit.next();
                if (null != agent.container && agent.isAccessible() && agentToAvoid != agent.address)
                {
                    res.add(agent.address);
                }
            }
        }
        return res;
    }
    /**
     * Creates a new list of agent's addresses, excluding the agent passed.
     * @param agentList original list
     * @param agentToAvoid agent not to be included in the new list
     * @return new list with addresses of agents
     */
    public static Collection<Address> addressExcludeAgentFromTheList(Collection<AgentKnowledge> agentList, Address agentToAvoid)
    {
        List<Address> res = new LinkedList<Address>();
        if (null != agentList)
        {
            for (Iterator<AgentKnowledge> oit = agentList.iterator(); oit.hasNext();)
            {
                AgentKnowledge agent = oit.next();
                if ( agentToAvoid != agent.address)
                {
                    res.add(agent.address);
                }
            }
        }
        return res;
    }

    /**
     * Creates a new list of agent's addresses, excluding the agent passed.
     * @param agentList original list
     * @param agentToAvoid agent not to be included in the new list
     * @return new list of AgentKnowledge objects
     */
    public static Collection<AgentKnowledge> excludeAgentFromTheList(Collection<AgentKnowledge> agentList, Address agentToAvoid)
    {
        List<AgentKnowledge> res = new LinkedList<AgentKnowledge>();
        if (null != agentList)
        {
            for (Iterator<AgentKnowledge> oit = agentList.iterator(); oit.hasNext();)
            {
                AgentKnowledge agent = oit.next();
                if ( agentToAvoid != agent.address)
                {
                    res.add(agent);
                }
            }
        }
        return res;
    }
}
