package across.util.skn.plan.across;

import java.io.FileInputStream;
import java.io.InputStream;

import across.data.TransportBatch;
import across.data.TransportCfp;
import across.data.TransportPlanBase;
import across.util.GoodsConstants;

public class Tester {

	static AcPlanner acp;
	
	public Tester() {
		
		TransportPlanBase tpb;
		try {
			tpb = (TransportPlanBase) getXML("xml//plan//planbase.xml",TransportPlanBase.class);
			acp = new AcPlanner(null, tpb);
			System.out.println(acp.getPlanBase().toString());
			AcPlanTemplate tp = acp.getPlanBase().combinePlans(acp.getPlanBase().selectPlans("Jakarta", "Pati"));
			System.out.println("Merge************************************");
			System.out.println(tp);
			
			System.out.println("************************************");
			System.out.println("Tasking************************************");
			TransportCfp cfp = new TransportCfp();
			cfp.setRequestid("1111");
			TransportBatch tb = new TransportBatch();
			tb.setBatchid(1);
			tb.setStartTime(1);
			tb.setTargetTime(1);
			tb.setStart("Jakarta");
			tb.setTarget("Pati");
			tb.setComodityName(GoodsConstants.FISH);
			tb.setCount(5000);
			cfp.getTransportBatch().add(tb);
			System.out.println(new AcPlan(tp, cfp,acp.getPlanBase()));
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public static Object getXML(String key, Class c) throws Exception {
	    FileInputStream in = new FileInputStream(key);
	    Object o = c.getMethod("unmarshal", new Class[] {InputStream.class}).invoke(null,
	        new Object[] {in});
	    in.close();
	    return o;
	}
	
	
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		new Tester();
	}

}
