package across.util.skn.plan.across;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

import across.data.TransportBatch;
import across.util.skn.AgentKnowledge;
import across.util.skn.plan.Action;
import across.util.skn.plan.Commitment;
import across.util.skn.util.membership.SimpleFuzzyMembership;
import aglobe.container.transport.Address;


/** Represents a commitment of agent to perform a specific action - transport the cargo specified by batches on actionReference */
public class AcTaskTransport extends Commitment {

	/** Batches to transport */
	List<TransportBatch> batches = new LinkedList<TransportBatch>();

	/** Batches to transport */
	List<AcTransCommitment> commitments = new LinkedList<AcTransCommitment>();

	/** References the generic action */
	AcTransport actionReference;

	/** References the plan to which this action belongs */
	AcPlan plan;

	public AcTaskTransport(AgentKnowledge responsible) {
		super(responsible);
	}

	public AcTaskTransport(AcTransport ac, AcPlan plan) {
		super(null);
		actionReference = ac;
		this.plan = plan;
	}

	@Override
	public SimpleFuzzyMembership getCompleted() {
		// TODO Auto-generated method stub
		return null;
	}

	public Action getActionReference() {
		return actionReference;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder("TASK: ");
		sb.append(actionReference.toString());
		sb.append("Batches: ");
		for (TransportBatch batch : batches) {
			sb.append(batch.getBatchid());
			sb.append(" ");
			sb.append(batch.getComodityName());
			sb.append(" ");
			sb.append(batch.getCount());
			sb.append(" % ");
		}
		sb.append("\nRes: ");
		for (AcTransCommitment comm : commitments) {
			sb.append(comm.toString());
			sb.append(" ");
		}
		sb.append("\n");
		return sb.toString();
	}

	public void addBatches(List<TransportBatch> allocated) {
		batches.addAll(allocated);
	}

	public void addBatch(TransportBatch batch) {
		batches.add(batch);
	}

	public long increaseBatch(TransportBatch tb) {
		for (TransportBatch cb : batches) {
			if ( tb.getBatchid() == cb.getBatchid() )
			{
				cb.setCount(cb.getCount() + tb.getCount());
				return tb.getCount();
			}
		}
		batches.add(tb);
		return tb.getCount();
	}

	public List<TransportBatch> getBatches() {
		return batches;
	}

	public void addCommitments(List<AcTransCommitment> comms) {
		commitments.addAll(comms);
	}

	public void addCommitments(AcTransCommitment comm) {
		commitments.add(comm);
	}

	public List<AcTransCommitment> getCommitments() {
		return commitments;
	}

	public Address getStartAddress() {
		//TODO will not work with inacc, rewrite
                Collection<Action> prer = actionReference.getPrerequisites();

		if ( ! prer.iterator().next().hasPrerequisites())
		{
			return plan.planBase.getCommunity().getOwnerAgentKnowledge().address;
		}
		else
		{
			// normal location, we assume that the agent name is the same as location name
			return plan.planBase.getCommunity().getAgent(actionReference.getStartNode()).address;
		}
	}

	public Address getTargetAddress() {
		// TODO will not work with inacc, rewrite
		// normal location, we assume that the agent name is the same as location name
		AgentKnowledge tagent = plan.planBase.getCommunity().getAgent(actionReference.getTargetNode());
		if (null != tagent){
			return tagent.address;
		} 
		// TODO - attention, we assume here that ALL agents share the same platform...
		Address ownA = plan.planBase.getCommunity().getOwnerAgent().getAddress();		
		return Address.getAgentAddress(ownA.getHost(), ownA.getPort(), actionReference.getTargetNode(), actionReference.getTargetNode()); 
	}

	public Collection<Address> getStartNodeIntrveningAgents() {
		Collection<Address> res = new HashSet<Address>();
		Collection<Action> prerList = getActionReference().getPrerequisites();
		for (Action action : prerList) {
			AcTaskTransport task = plan.getTask(action.getActionDescriptor());
			if ( null != task)
			{
				task.writeNodeIntrveningAgents(res);
			}
		}
		return res;
	}

	public Collection<Address> getTargetNodeIntrveningAgents() {
		Collection<Address> res = new HashSet<Address>();
		Collection<Action> allList = getActionReference().getAllows();
		for (Action action : allList) {
			AcTaskTransport task = plan.getTask(action.getActionDescriptor());
			if ( null != task)
			{
				task.writeNodeIntrveningAgents(res);
			}
		}
		return res;
	}

	private void writeNodeIntrveningAgents(Collection<Address> res) {
		for( Action act:  getActionReference().getPrerequisites())
		{
			AcTaskTransport tsk = plan.getTask(act.getActionDescriptor());
			if(null != tsk)
			{
				for (AcTransCommitment com : tsk.commitments) {
					res.add(com.getAgent().address);
				}
			}
		}
	}

	/** Returns all agents who have commited their resources to the task */
	public Collection<AgentKnowledge> getCommitedTeam() {
		HashSet<AgentKnowledge> res = new HashSet<AgentKnowledge>();
		for(Commitment comm : commitments)
		{
			if (!res.contains(comm.getAgent()))
			{
				res.add(comm.getAgent());
			}
		}
		return res;
	}
}
