package across.util.skn.plan.across;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import across.data.AdvTeamProposal;
import across.data.Node;
import across.data.TeamProposal;
import across.data.TransportBatch;
import across.data.TransportCfp;
import across.data.TransportPlanBase;
import across.util.skn.CommunityKnowledge;
import across.util.skn.plan.Planner;
import aglobe.container.transport.Address;

/**
 * This is the main planner class.
 * Uses PlanBase to combine plans and to allocate tasks and resources to actions.
 */
public class AcPlanner implements Planner {

	private PlanBase planBase;
	private CommunityKnowledge community;
	
	/**
	 * @param community pointer to the community knowledge structure
	 * @param tpb plan templates to load into the PlanBase
	 */
	public AcPlanner(CommunityKnowledge community, TransportPlanBase tpb) {
		super();
		this.community = community;
		planBase = new PlanBase(community);
		planBase.loadFromXml(tpb);
	}

	/**
	 * @return Returns the community.
	 */
	protected CommunityKnowledge getCommunity() {
		return community;
	}

	/* (non-Javadoc)
	 * @see across.skn.plan.across.Planner#getPlanBase()
	 */
	public PlanBase getPlanBase() {
		return planBase;
	}
	
	public void setupNodes(HashMap<String, Node> nodes)
	{
		planBase.setupNodes(nodes);
	};
	
	public AcPlanTemplate producePlanTemplate(TransportCfp cfp)
	{
		// get the start and target - both are single locations so far
		String startLoc = ((TransportBatch)(cfp.getTransportBatch().get(0))).getStart();
		String targetLoc = ((TransportBatch)(cfp.getTransportBatch().get(0))).getTarget();
		List<AcPlanTemplate> selectedPlans = planBase.selectPlans(startLoc, targetLoc);
		if (!selectedPlans.isEmpty())
		{
			// combine the plans if any found
			return getPlanBase().combinePlans(selectedPlans);
		}
		return null;
	}

	public AcPlan producePlanInstance(TransportCfp cfp)
	{
		AcPlanTemplate pt = producePlanTemplate(cfp);
		if ( null != pt)
		{
			AcPlan plan = new AcPlan(pt, cfp, getPlanBase());
			return plan;
		}
		return null;
	};

	/**
	 * Transforms the plan into the list of team proposals.
	 * @param plan plan to transform
	 * @return zero-length list if plan is null, map of proposals to send to agents otherwise
	 */
	public LinkedHashMap<Address,AdvTeamProposal> prepareTeamProposals(AcPlan plan)
	{
		LinkedHashMap<Address,AdvTeamProposal> res = new LinkedHashMap<Address,AdvTeamProposal>();
		if (null != plan)
		{
			for (AcTaskTransport task : plan.getTaskList()) {
				Map<Address,TeamProposal> actionRes = new LinkedHashMap<Address,TeamProposal>();
//				String start = ((AcTransport)task.getActionReference()).getStartNode();
//				String target = ((AcTransport)task.getActionReference()).getTargetNode();
				// will be used for array of proposals...
				for (AcTransCommitment comm : task.getCommitments()) {
					TeamProposal tp = actionRes.get(comm.getAgent().address);
					if (null == tp)
					{
						tp = new TeamProposal();
						TransportCfp atcfp = new TransportCfp();
						atcfp.setRequestid(task.getActionReference().getActionDescriptor());
						atcfp.setRequestTime(plan.tcfp.getRequestTime());
						tp.setRequestedServices(atcfp);
						tp.setTransportCfp(plan.tcfp);
						actionRes.put(comm.getAgent().address,tp);
					}
					tp.getRequestedServices().getTransportBatch().add(comm.getBatch());
/*					tp.getRequestedServices().getTransportBatch().add(ListBatchTools.copyTransportBatch(
							comm.getBatch(), start, task.getStartAddress(), target, task.getTargetAddress()));
*/				}
				// finalize the proposals
				Collection<Address> startAgents = task.getStartNodeIntrveningAgents();
				Collection<Address> targetAgents = task.getTargetNodeIntrveningAgents();
				for (Map.Entry<Address, TeamProposal> pair : actionRes.entrySet()) {
					TeamProposal tp = pair.getValue();
					tp.setTeamLeader(community.getOwnerAgentKnowledge().address);
					tp.getTeamMember().addAll(actionRes.keySet());
					tp.getStartNodeTeamMember().addAll(startAgents);
					tp.getTargetNodeTeamMember().addAll(targetAgents);
					updateAdvProposal(res, pair.getKey(), tp);
				}
			}
			// update member list of aech big proposal...
			for (AdvTeamProposal atp : res.values()) {
				atp.getTeamMember().addAll(res.keySet());
			}
		}
		return res;
	}
	private void updateAdvProposal(Map<Address, AdvTeamProposal> res, Address key, TeamProposal tp) {
		AdvTeamProposal atp = res.get(key);
		if (null == atp)
		{
			atp = new AdvTeamProposal();
			atp.setTeamLeader(community.getOwnerAgentKnowledge().address);
			atp.setThisMember(key);
			res.put(key, atp);
		}
		atp.getTask().add(tp);
	}
}
