package across.util.skn.plan;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/**
 * This class represents a complete plan - it describes necessary milestone objectives and actions  
 *
 */
public abstract class PlanTemplate extends Action{

	/** Plan intermediary milestones - not mandatory, connected by actions. Contains prerequisites and achieves lists members (inherited).*/
	protected LinkedList<Action> objectives = new LinkedList<Action>();
	/** Actions that connect the objectives */
	protected LinkedList<Action> actions = new LinkedList<Action>();
	
	public PlanTemplate() {
		super("PLAN");
	}

	public PlanTemplate(Collection<? extends Action> actions2, Collection<? extends Action> objectives2) {
		super("PLAN");
		actions.addAll(actions2);
		objectives.addAll(objectives2);
	}

	/**
	 * @return Returns the actions.
	 */
	public List<Action> getActions() {
		return actions;
	}
	
	/**
	 * @return Returns the objectives.
	 */
	public List<Action> getObjectives() {
		return objectives;
	}

	/* (non-Javadoc)
	 * @see across.skn.plan.Action#getActionDescriptor()
	 */
	@Override
	public String getActionDescriptor() {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see across.skn.plan.Action#toString()
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder("***** PLAN LISTING  *****\n");
		for (Action prer : getPrerequisites()) {
			sb.append("*** Prer: \n");
			sb.append(prer.toString());
			sb.append("\n");
		}
		for (Action action : getActions()) {
			sb.append("*** Action: \n");
			sb.append(action.toString());
			sb.append("\n");
		}
		for (Action action : getObjectives()) {
			sb.append("*** Objective: \n");
			sb.append(action.toString());
			sb.append("\n");
		}
		for (Action action : getAllows()) {
			sb.append("*** Allows/Achieves: \n");
			sb.append(action.toString());
			sb.append("\n");
		}
		return sb.toString();
	}
	
	
	
	
}
