package across.util.skn.plan;

import across.util.skn.AgentKnowledge;
import across.util.skn.util.membership.SimpleFuzzyMembership;


/**
 * Represents a commitment of resources/agents to the Action. Commitmants form a specific plan.
 * Resources that are commited and specification of commitments are domain specific.
 */
public abstract class Commitment {
	
	/** Commiting agent */
	private AgentKnowledge agent;
	//TODO - shall we consider coalition commitments ?
	
	
	
	public abstract SimpleFuzzyMembership getCompleted();

	public Commitment(AgentKnowledge agent) {
		super();
		this.agent = agent;
	}

	public AgentKnowledge getAgent() {
		return agent;
	}

	public void setAgent(AgentKnowledge agent) {
		this.agent = agent;
	}
}
