package across.util.skn.gui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import across.data.Param;
import across.data.PublicParams;
import across.data.Resource;
import across.data.SemiPrivateParams;
import across.util.skn.AgentKnowledge;
import across.util.skn.ServiceKnowledge;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 */

public class ServiceProvidersDataModel  {

 HashMap services = new HashMap();
 DefaultMutableTreeNode root;
 DefaultTreeModel treeModel;

 public ServiceProvidersDataModel(DefaultTreeModel _treeModel, DefaultMutableTreeNode _root) {
  root = _root;
  treeModel = _treeModel;
 }

 public void update(ServiceKnowledge sk) {
  String name = sk.serviceName;
  if (!services.containsKey(name)) {
    DefaultMutableTreeNode newService = new DefaultMutableTreeNode(name);
    services.put(name, newService);
    root.add(newService);
    addProviders(newService, sk.getAllMembers());
  } else {
     DefaultMutableTreeNode oldService = (DefaultMutableTreeNode)services.get(name);
     oldService.removeAllChildren();
     addProviders(oldService, sk.getAllMembers());
    }
  treeModel.reload(root);
 }

 private void addProviders(DefaultMutableTreeNode myRoot, List providers) {
   for (Iterator i = providers.iterator(); i.hasNext();) {
     AgentKnowledge ak = (AgentKnowledge)i.next();
     DefaultMutableTreeNode agentNode = new DefaultMutableTreeNode(ak.address.getName());
     myRoot.add(agentNode);

     DefaultMutableTreeNode publicParamsNode = new DefaultMutableTreeNode(
         "public params");
     agentNode.add(publicParamsNode);
     addPublicParamsToTree(ak.publicParams, publicParamsNode);

     DefaultMutableTreeNode semiPrivateParamsNode = new
             DefaultMutableTreeNode("semi-private params");
     agentNode.add(semiPrivateParamsNode);
     addSemiPrivateParamsToTree(ak.semiPrivateParams,
                                semiPrivateParamsNode);

   }
 }


 private void addPublicParamsToTree(PublicParams pp, DefaultMutableTreeNode myRoot)
 {
   if (pp != null) {
     java.util.List namesValues = pp.getParam();

     int size = namesValues.size();
     for (int i = 0; i < size; i++) {
       Param p = (Param) namesValues.get(i);
       myRoot.add(new DefaultMutableTreeNode(p.getName() + " = " + p.getValue()));
     }
   }
 }

 private void addSemiPrivateParamsToTree(SemiPrivateParams sp, DefaultMutableTreeNode myRoot)
 {
   if (sp != null) {
     java.util.List namesValues = sp.getParam();

     int size = namesValues.size();
     for (int i = 0; i < size; i++) {
       Param p = (Param) namesValues.get(i);
       myRoot.add(new DefaultMutableTreeNode(p.getName() + " = " + p.getValue()));
     }

     List rList = sp.getResource();
     for (Iterator i = rList.iterator(); i.hasNext();) {
       Resource r = (Resource)i.next();
       myRoot.add(new DefaultMutableTreeNode("Type: "+r.getType()+" Capacity: "+ r.getCapacity()));
     }
   }
 }



}