package across.util.skn.gui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

import across.data.Param;
import across.data.PublicParams;
import across.data.Resource;
import across.data.SemiPrivateParams;
import across.util.skn.AgentKnowledge;
import across.util.skn.AllianceKnowledge;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 */

public class AlliancesDataModel {

 private HashMap alliancesNodes = new HashMap(); // tree nodes
 private String alliance; // alliance of knowledge owner
 private DefaultTreeModel alliancesTreeModel;
 private DefaultMutableTreeNode alliancesRoot;
 private Boolean myAlliance; // flag for display my alliance only


 public AlliancesDataModel(DefaultTreeModel _alliancesTreeModel, DefaultMutableTreeNode
  _alliancesRoot, Boolean _myAlliance) {

    alliancesTreeModel = _alliancesTreeModel;
    alliancesRoot = _alliancesRoot;
    myAlliance = _myAlliance;
 }


  public void update(AllianceKnowledge ak) {
   if (ak == null) return;



   String name = ak.getName();
   if (!alliancesNodes.containsKey(name)) {
     if (((ak.getName().equalsIgnoreCase(alliance)) & (myAlliance.booleanValue())) || (!myAlliance.booleanValue())) {

       DefaultMutableTreeNode newAlliance = new DefaultMutableTreeNode(name);
       alliancesNodes.put(name, newAlliance);

       alliancesRoot.add(newAlliance);

       for (AgentKnowledge agk : ak.getAllMembers()) {
         DefaultMutableTreeNode newAgentNode = new DefaultMutableTreeNode(agk.
             address.getName());
         newAlliance.add(newAgentNode);

         DefaultMutableTreeNode publicParamsNode = new DefaultMutableTreeNode(
             "public params");
         newAgentNode.add(publicParamsNode);
         addPublicParamsToTree(agk.publicParams, publicParamsNode);

         DefaultMutableTreeNode semiPrivateParamsNode = new
                 DefaultMutableTreeNode("semi-private params");
         newAgentNode.add(semiPrivateParamsNode);
         addSemiPrivateParamsToTree(agk.semiPrivateParams,
                                    semiPrivateParamsNode);
       }
     }
   } else {
       DefaultMutableTreeNode oldNode = (DefaultMutableTreeNode)
           alliancesNodes.get(name);
       oldNode.removeAllChildren();
       for (AgentKnowledge agk : ak.getAllMembers()) {
         DefaultMutableTreeNode agentNode = new DefaultMutableTreeNode(agk.
             address.getName());
         oldNode.add(agentNode);

         DefaultMutableTreeNode publicParamsNode = new DefaultMutableTreeNode(
             "public params");
         agentNode.add(publicParamsNode);
         addPublicParamsToTree(agk.publicParams, publicParamsNode);

         DefaultMutableTreeNode semiPrivateParamsNode = new
                 DefaultMutableTreeNode("semi-private params");
         agentNode.add(semiPrivateParamsNode);
         addSemiPrivateParamsToTree(agk.semiPrivateParams,
                                    semiPrivateParamsNode);

       }
   }
   alliancesTreeModel.reload(alliancesRoot);
  }

  private void addPublicParamsToTree(PublicParams pp, DefaultMutableTreeNode myRoot)
  {
    if (pp != null) {
      java.util.List namesValues = pp.getParam();

      int size = namesValues.size();
      for (int i = 0; i < size; i++) {
        Param p = (Param) namesValues.get(i);
        myRoot.add(new DefaultMutableTreeNode(p.getName() + " = " + p.getValue()));
      }
    }
  }

  private void addSemiPrivateParamsToTree(SemiPrivateParams sp, DefaultMutableTreeNode myRoot)
  {
    if (sp != null) {
      java.util.List namesValues = sp.getParam();

      int size = namesValues.size();
      for (int i = 0; i < size; i++) {
        Param p = (Param) namesValues.get(i);
        myRoot.add(new DefaultMutableTreeNode(p.getName() + " = " + p.getValue()));
      }

      List rList = sp.getResource();
      for (Iterator i = rList.iterator(); i.hasNext();) {
        Resource r = (Resource)i.next();
        myRoot.add(new DefaultMutableTreeNode("Type: "+r.getType()+" Capacity: "+ r.getCapacity()));
      }
    }
  }

 public void remove(AgentKnowledge ak) {
  update(ak.alliance);
  if (ak.alliance.getAllMembersCount() == 0) {
    remove(ak.alliance);
  }
 }

 public void remove(AllianceKnowledge ak) {
  DefaultMutableTreeNode removedAlliance = (DefaultMutableTreeNode)alliancesNodes.get(ak.getName());
  if (removedAlliance != null) {
   MutableTreeNode parent = (MutableTreeNode)removedAlliance.getParent();
   parent.remove(removedAlliance);
   alliancesTreeModel.reload(alliancesRoot);

   alliancesNodes.remove(ak.getName());
  }
 }

 public void setAlliance(String _alliance) {
  alliance = _alliance;
 }


}
